/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.suggestion.rules.reader;

import com.ibm.bi.predict.sa.suggestion.rules.reader.ExcelReader;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import com.ibm.bi.predict.utils.StreamUtils;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class ExcelTableReader
implements ExcelReader {
    private static final Logger logger = PredictLoggerFactory.getLogger(ExcelTableReader.class);
    private Workbook workbook;

    public ExcelTableReader(File workbookFile) {
        this(ExcelTableReader.workbookFromFile(workbookFile));
        logger.info("Read file: {}", (Object)workbookFile.getName());
    }

    public ExcelTableReader(Workbook workbook) {
        this.workbook = workbook;
    }

    @Override
    public String[] readRow(String sheetName, int rowIndex) {
        Row row = this.workbook.getSheet(sheetName).getRow(rowIndex);
        return this.readRow(row);
    }

    @Override
    public String[][] readTable(String sheetName, int requiredColumns, boolean hasHeader, boolean padEmptyColumns) {
        String[] header;
        Sheet sheet = this.workbook.getSheet(sheetName);
        if (hasHeader && sheet.getLastRowNum() > 0 && (header = this.readRow(sheet.getRow(0))).length != requiredColumns) {
            throw new IllegalStateException(String.format("Required table width to be %d, but header had width %d", requiredColumns, header.length));
        }
        return this.readRowsOfSheet(sheet, requiredColumns, hasHeader, padEmptyColumns);
    }

    private String[][] readRowsOfSheet(Sheet sheet, int numExpectedColumns, boolean hasHeader, boolean padEmptyColumns) {
        return (String[][])StreamUtils.fromIterator((Iterator)sheet.rowIterator()).skip(hasHeader ? 1L : 0L).map(row -> {
            short numCells = row.getLastCellNum();
            if (numCells < numExpectedColumns && !padEmptyColumns) {
                throw new IllegalStateException(String.format("%s @ %d: Expected row of length %d, but was %d", sheet.getSheetName(), row.getRowNum(), numExpectedColumns, row.getLastCellNum()));
            }
            return this.readRow((Row)row, numExpectedColumns);
        }).toArray(x$0 -> new String[x$0][]);
    }

    private String[] readRow(Row row) {
        return this.readRow(row, (int)row.getLastCellNum());
    }

    private String[] readRow(Row row, int numExpectedColumns) {
        String[] cells = new String[numExpectedColumns];
        for (int i = 0; i < numExpectedColumns; ++i) {
            cells[i] = this.cellValue(row.getCell(i));
        }
        return cells;
    }

    private String cellValue(Cell cell) {
        if (cell == null) {
            return null;
        }
        CellType type = cell.getCellTypeEnum();
        if (type == CellType.NUMERIC) {
            return Double.toString(cell.getNumericCellValue());
        }
        return cell.getRichStringCellValue().getString().trim();
    }

    private static Workbook workbookFromFile(File file) {
        try {
            return WorkbookFactory.create((File)file);
        }
        catch (IOException e) {
            logger.error("Unreadable File: {}", (Object)file.getPath(), (Object)e);
            throw new RuntimeException(e);
        }
    }
}

