/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.suggestion.service;

import com.ibm.bi.predict.exceptions.BadParametersException;
import com.ibm.bi.predict.sa.execution.annotation.MessageService;
import com.ibm.bi.predict.sa.execution.annotation.MessageServiceImpl;
import com.ibm.bi.predict.sa.suggestion.api.request.AnnotationRequest;
import com.ibm.bi.predict.sa.suggestion.domain.Annotation;
import com.ibm.bi.predict.sa.suggestion.domain.AnnotationDefinitions;
import com.ibm.bi.predict.sa.suggestion.domain.Annotations;
import com.ibm.bi.predict.sa.suggestion.service.AnnotationService;
import com.ibm.bi.predict.sa.suggestion.service.AnnotationsGenerator;
import com.ibm.bi.predict.sa.suggestion.service.DefinitionLoader;
import com.ibm.bi.predict.service.PredictServiceRequest;
import com.ibm.bi.predict.service.PredictServiceResponse;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.LazyInitializer;

public class DefinitionDrivenAnnotationService
implements AnnotationService {
    private static final Logger logger = PredictLoggerFactory.getLogger(DefinitionDrivenAnnotationService.class);
    private final DefinitionLoader definitionLoader;
    private final AnnotationsGenerator annotationsGenerator;
    private final MessageService messages;
    private LazyInitializer<Optional<AnnotationDefinitions>> definition = new LazyInitializer<Optional<AnnotationDefinitions>>(){

        protected Optional<AnnotationDefinitions> initialize() {
            logger.debug("Initializing annotation definitions");
            return DefinitionDrivenAnnotationService.this.definitionLoader.load();
        }
    };

    public DefinitionDrivenAnnotationService(DefinitionLoader defLoader, AnnotationsGenerator annotationsGenerator) {
        this(defLoader, annotationsGenerator, (MessageService)new MessageServiceImpl());
    }

    public DefinitionDrivenAnnotationService(DefinitionLoader defLoader, AnnotationsGenerator annotationsGenerator, MessageService messages) {
        this.definitionLoader = defLoader;
        this.annotationsGenerator = annotationsGenerator;
        this.messages = messages;
    }

    public PredictServiceResponse run(Collection<PredictServiceRequest> requests, Locale locale) {
        if (requests.isEmpty()) {
            throw new BadParametersException("No requests were provided to the annotations service");
        }
        PredictServiceRequest request = requests.iterator().next();
        return this.getSuitableAnnotations((AnnotationRequest)request.getContext(), request.getLocale());
    }

    @Override
    public Annotations getSuitableAnnotations(AnnotationRequest request, Locale locale) {
        MessageService.MessageBundle messageBundle = this.messages.getMessageBundle("Predict_Smart_Annotations", locale);
        Optional<AnnotationDefinitions> definitions = this.getDefinitions();
        if (!definitions.isPresent()) {
            return new Annotations(Collections.emptyList(), Collections.emptyMap(), messageBundle);
        }
        List<Annotation> annotations = this.annotationsGenerator.generateAnnotations(request, definitions.get());
        logger.debug("Completed generation of annotation suggestions - numSuggestions={}", (Object)annotations.size());
        Map<String, String> captions = this.getCaptions(annotations, messageBundle);
        return new Annotations(annotations, captions, messageBundle);
    }

    private Map<String, String> getCaptions(List<Annotation> annotations, MessageService.MessageBundle captionBundle) {
        return annotations.stream().collect(Collectors.toMap(Annotation::getType, a -> captionBundle.getMessage(a.getType(), new Object[0]), (existingCaptionKey, newCaptionKey) -> existingCaptionKey));
    }

    private Optional<AnnotationDefinitions> getDefinitions() {
        logger.debug("Getting annotation definitions");
        try {
            Optional def = (Optional)this.definition.get();
            if (!def.isPresent()) {
                logger.warn("No annotation definitions found");
            }
            return def;
        }
        catch (ConcurrentException e) {
            logger.error("Error while getting annotation definitions - message={}", (Object)e.getMessage(), (Object)e);
            return Optional.empty();
        }
    }
}

