/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.suggestion.service;

import com.ibm.bi.predict.dataaccess.json.JsonDataAccessProvider;
import com.ibm.bi.predict.sa.execution.api.DataAccessProviderFactory;
import com.ibm.bi.predict.sa.execution.api.ExecutionRequestMapper;
import com.ibm.bi.predict.sa.execution.api.ExecutionResponse;
import com.ibm.bi.predict.sa.execution.service.ExecutionServiceFactory;
import com.ibm.bi.predict.sa.execution.service.ExecutionServiceFactoryImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.json.JSONObject;

public class ExecutionServiceGateway {
    private final ExecutionRequestMapper requestMapper;
    private final ExecutionServiceFactory executionServiceFactory;

    public ExecutionServiceGateway(ExecutionRequestMapper requestMapper, ExecutionServiceFactory executionServiceFactory) {
        this.requestMapper = requestMapper;
        this.executionServiceFactory = executionServiceFactory;
    }

    public ExecutionResponse executeRequest(JSONObject input, Locale locale) {
        List requests = this.requestMapper.mapJsonToRequests(input, locale, Collections.emptyMap());
        return (ExecutionResponse)this.executionServiceFactory.make().run((Collection)requests, locale);
    }

    public ExecutionResponse executeRequest(JSONObject input, Locale locale, Map<String, Object> extraInfo) {
        List requests = this.requestMapper.mapJsonToRequests(input, locale, extraInfo);
        return (ExecutionResponse)this.executionServiceFactory.make().run((Collection)requests, locale);
    }

    public static class Factory {
        DataAccessProviderFactory<JSONObject> dataAcessProviderFactory = (inputData, concepts) -> new JsonDataAccessProvider((JSONObject)inputData.getData(), concepts);

        public ExecutionServiceGateway make() {
            return new ExecutionServiceGateway(new ExecutionRequestMapper(this.dataAcessProviderFactory), new ExecutionServiceFactoryImpl());
        }
    }
}

