/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.data;

import com.ibm.bi.predict.data.Range;
import com.ibm.bi.predict.dataaccess.types.AggregationType;
import com.ibm.bi.predict.messages.Messages;
import com.ibm.bi.predict.types.SpecialType;
import com.ibm.bi.predict.utils.StringUtils;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.lang3.builder.EqualsBuilder;

public final class Category {
    public static final Category ZERO = new Category(SpecialType.Category_ZERO);
    public static final Category MISSING = new Category(SpecialType.Category_MISSING);
    public static final Category OTHER = new Category(SpecialType.Category_OTHER);
    private final Object content;
    private final int identifier;
    private int sortIndex;
    private AggregationType aggregationType;

    private Category(Object content) {
        this(content, -1);
    }

    private Category(Object content, int identifier) {
        if (content == null) {
            throw new NullPointerException("Category content may not be null");
        }
        this.content = content;
        this.identifier = identifier;
    }

    public static Category forBin(double a, double b) {
        return new Category(new Range(a, b));
    }

    public static Category forString(String value) {
        return new Category(StringUtils.toBytes((String)value));
    }

    public static Category forString(String value, int identifier) {
        return new Category(StringUtils.toBytes((String)value), identifier);
    }

    public int identifier() {
        return this.identifier;
    }

    public Range asBounds() {
        return this.content instanceof Range ? (Range)this.content : null;
    }

    public String asString(Locale locale) {
        if (this.content instanceof byte[]) {
            return StringUtils.fromBytes((byte[])((byte[])this.content));
        }
        if (this.content instanceof SpecialType) {
            SpecialType category = (SpecialType)this.content;
            Messages messages = Messages.getMessagesFor((String)"Predict_Messages", (Locale)locale);
            return messages.get(category.toString(), new Object[0]);
        }
        return null;
    }

    public boolean special() {
        return this.content instanceof Enum;
    }

    public final String toString() {
        if (this.content instanceof byte[]) {
            return StringUtils.fromBytes((byte[])((byte[])this.content));
        }
        return this.content.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Category)) {
            return false;
        }
        Category other = (Category)obj;
        return new EqualsBuilder().append(this.content, other.content).isEquals();
    }

    public int hashCode() {
        return Objects.hashCode(this.toString());
    }

    public void setSortIndex(int index) {
        this.sortIndex = index;
    }

    public int getSortIndex() {
        return this.sortIndex;
    }

    public Category setAggregationType(AggregationType aggregationType) {
        this.aggregationType = aggregationType;
        return this;
    }

    public AggregationType getAggregationType() {
        return this.aggregationType;
    }
}

