/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.data;

import com.ibm.bi.predict.data.Category;
import com.ibm.bi.predict.data.SummaryData;
import com.ibm.bi.predict.data.store.DataArray;
import com.ibm.bi.predict.dataaccess.types.AggregationType;
import com.ibm.bi.predict.dataaccess.types.FieldType;
import com.ibm.bi.predict.math.NumericUtils;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import com.ibm.bi.predict.utils.Tuple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleUnaryOperator;

public class DataColumn {
    private final ColumnMeta meta;
    private List<Category> categories;
    private List<DataArray> nestedDataArrays = new ArrayList<DataArray>();
    private List<Set<Category>> nestedCategories = new ArrayList<Set<Category>>();
    private DataArray data;
    private Set<Status> status;
    private SummaryData summary = new SummaryData();
    private final int index;
    private List<DataColumn> nestedColumns;
    private DataColumn parent;
    private static final Logger LOG = PredictLoggerFactory.getLogger(DataColumn.class);

    public DataColumn(ColumnMeta meta, List<Category> categories, double[] data, int index) {
        this(meta, categories, DataArray.of(data), new LinkedHashSet<Status>(), index);
    }

    public DataColumn(ColumnMeta meta, List<Category> categories, double[] data, Set<Status> status, int index) {
        this(meta, categories, DataArray.of(data), status, index);
    }

    public DataColumn(ColumnMeta meta, List<Category> categories, DataArray data, Set<Status> status, int index) {
        this.meta = meta;
        this.categories = categories;
        this.data = data;
        this.status = status;
        this.index = index;
    }

    public DataColumn(ColumnMeta meta, List<Category> categories, double[] data) {
        this(meta, categories, DataArray.of(data), new LinkedHashSet<Status>(), 0);
    }

    public DataColumn(ColumnMeta meta, List<Category> categories, double[] data, Set<Status> status) {
        this(meta, categories, DataArray.of(data), status, 0);
    }

    public DataColumn copy() {
        return this.copyWithData(this.data);
    }

    public DataColumn copyWithData(DataArray data) {
        ArrayList<Category> categoriesCopy = this.categories != null ? new ArrayList<Category>(this.categories) : null;
        return new DataColumn(this.meta, categoriesCopy, data, new LinkedHashSet<Status>(this.status), this.index).setParent(this.parent);
    }

    public DataColumn copyWithNewDataAndCategories(double[] newDataValues, List<Category> newCategories) {
        DataArray newDataArray = DataArray.of(newDataValues);
        return new DataColumn(this.meta, newCategories, newDataArray, new LinkedHashSet<Status>(this.status), this.index).setParent(this.parent);
    }

    public DataColumn copyWithoutRows(Collection<Integer> rowsToRemove) {
        double[] newData = new double[this.rowCount() - rowsToRemove.size()];
        int newDataIndex = 0;
        PrimitiveIterator.OfDouble dataIter = this.getDataArray().iterator();
        for (int i = 0; i < this.rowCount(); ++i) {
            if (rowsToRemove.contains(i)) {
                dataIter.next();
                continue;
            }
            newData[newDataIndex] = dataIter.next();
            ++newDataIndex;
        }
        return this.copyWithData(DataArray.of(newData));
    }

    public boolean hasNestedDataColumns() {
        return this.getMeta().getFieldIds().size() > 1;
    }

    public List<DataColumn> getNestedDataColumns() {
        if (this.nestedColumns != null) {
            return this.nestedColumns;
        }
        this.nestedColumns = new ArrayList<DataColumn>();
        List<String> fieldIds = this.getMeta().getFieldIds();
        if (fieldIds.size() <= 1) {
            return this.nestedColumns;
        }
        List<String> fieldLabels = this.getMeta().getFieldLabels();
        Map<String, String> uniqueIds = this.getMeta().getUniqueIds();
        Map<String, List<Tuple<String, Double>>> conceptsMap = this.getMeta().getConceptsMap();
        for (int i = 0; i < fieldIds.size(); ++i) {
            String uniqueId = uniqueIds.get(fieldIds.get(i));
            List<Object> concepts = conceptsMap.get(uniqueId);
            if (uniqueId == null || concepts == null) {
                LOG.warn("Unable to map nested field id to a set of concepts. Continuing with an empty set.");
                concepts = Collections.emptyList();
            }
            this.nestedColumns.add(this.buildNestedCol(fieldIds.get(i), fieldLabels.get(i), concepts, this.getSubfieldCategories(i), this.getSubfieldDataArray(i), i));
        }
        return this.nestedColumns;
    }

    private List<Category> getSubfieldCategories(int index) {
        ArrayList<Category> subfieldCats = new ArrayList<Category>();
        if (this.nestedCategories.size() > index) {
            subfieldCats = new ArrayList(this.nestedCategories.get(index));
        }
        return subfieldCats;
    }

    private DataArray getSubfieldDataArray(int index) {
        DataArray subfieldDataArray = DataArray.of(new double[0]);
        if (this.nestedDataArrays.size() > index) {
            subfieldDataArray = this.nestedDataArrays.get(index);
        }
        return subfieldDataArray;
    }

    private DataColumn buildNestedCol(String fieldId, String fieldLabel, List<Tuple<String, Double>> concepts, List<Category> categories, DataArray dataArray, int i) {
        ColumnMeta columnMeta = new ColumnMeta(fieldId, fieldLabel, this.getMeta().getType(), this.getMeta().getAggregationType(), concepts, Collections.emptyList(), Collections.emptyList(), Collections.emptyMap(), Collections.emptyMap());
        DataColumn column = new DataColumn(columnMeta, categories, dataArray, this.getStatus(), this.index).setParent(this);
        return column;
    }

    public int getCategoryCount() {
        return this.categories != null ? this.categories.size() : -1;
    }

    public int getNonEmptyCategoryCount() {
        if (this.categories == null) {
            return -1;
        }
        return (int)this.data.stream().distinct().count();
    }

    public List<Category> getCategories() {
        return this.categories;
    }

    public Category getCategory(int index) {
        return this.categories.get(index);
    }

    public Category getCategoryByDataIndex(int index) {
        return this.categories.get((int)this.data.value(index));
    }

    public void setCategories(List<Category> categories) {
        this.categories = categories;
    }

    public void setData(DataArray data) {
        this.data = data;
    }

    public void addCategory(Category category) {
        this.categories.add(category);
    }

    public DataColumn reorder(int[] rowOrder) {
        double[] newData = new double[this.data.size()];
        for (int i = 0; i < rowOrder.length; ++i) {
            newData[i] = this.getValue(rowOrder[i]);
        }
        DataColumn column = this.copyWithData(DataArray.of(newData));
        return column;
    }

    public double getValue(int row) {
        return this.data.value(row);
    }

    public DataColumn replaceValues(DoubleUnaryOperator replacementFunction) {
        double[] newData = new double[this.data.size()];
        for (int i = 0; i < newData.length; ++i) {
            newData[i] = replacementFunction.applyAsDouble(this.data.value(i));
        }
        this.data = DataArray.of(newData);
        return this;
    }

    public DataColumn replaceValues(BiFunction<Integer, Double, Double> replacementFunction) {
        double[] newData = new double[this.data.size()];
        for (int i = 0; i < newData.length; ++i) {
            newData[i] = replacementFunction.apply(i, this.data.value(i));
        }
        return this.copyWithData(DataArray.of(newData));
    }

    public <T extends DoubleConsumer> T dataPass(T function) {
        this.data.iterator().forEachRemaining(function);
        return function;
    }

    public ColumnMeta getMeta() {
        return this.meta;
    }

    public String getId() {
        return this.meta.getId();
    }

    public int getIndex() {
        return this.index;
    }

    public String getLabel() {
        return this.meta.getLabel();
    }

    public FieldType getType() {
        return this.meta.getType();
    }

    public AggregationType getAggregationType() {
        return this.meta.getAggregationType();
    }

    public int rowCount() {
        return this.data.size();
    }

    public Set<Status> getStatus() {
        return this.status;
    }

    public boolean hasStatus(Status status) {
        return this.status.contains((Object)status);
    }

    public DataColumn addStatus(Status status) {
        this.status.add(status);
        return this;
    }

    public DataArray getDataArray() {
        return this.data;
    }

    public SummaryData getSummaryData() {
        return this.summary;
    }

    public boolean valuesSame(double[] expected) {
        if (expected.length != this.rowCount()) {
            return false;
        }
        for (int i = 0; i < expected.length; ++i) {
            double a = expected[i];
            double b = this.getValue(i);
            if (NumericUtils.isMissingValue((double)a) && NumericUtils.isMissingValue((double)b) || NumericUtils.equals((double)a, (double)b)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.meta.getId();
    }

    public DataColumn getParent() {
        if (this.parent == null) {
            throw new IllegalStateException("Attempting to access the parent column of a nested column but the parent has not been set.");
        }
        return this.parent;
    }

    public DataColumn setParent(DataColumn parent) {
        this.parent = parent;
        return this;
    }

    public void setNestedFields(Tuple<List<Set<Category>>, List<DataArray>> nestedFields) {
        this.nestedCategories = (List)nestedFields._1;
        this.nestedDataArrays = (List)nestedFields._2;
    }

    public static class ColumnMeta {
        private final String id;
        private final String label;
        private final FieldType fieldType;
        private final AggregationType aggregationType;
        private final List<Tuple<String, Double>> concepts;
        private final List<String> fieldIds;
        private final List<String> fieldLabels;
        private final Map<String, String> uniqueIds;
        private final Map<String, List<Tuple<String, Double>>> conceptsMap;

        public ColumnMeta(String id, String label, FieldType fieldType, AggregationType aggregationType) {
            this(id, label, fieldType, aggregationType, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyMap(), Collections.emptyMap());
        }

        public ColumnMeta(String id, String label, FieldType fieldType, AggregationType aggregationType, List<Tuple<String, Double>> concepts) {
            this(id, label, fieldType, aggregationType, concepts, Collections.emptyList(), Collections.emptyList(), Collections.emptyMap(), Collections.emptyMap());
        }

        public ColumnMeta(String id, String label, FieldType fieldType, AggregationType aggregationType, List<Tuple<String, Double>> concepts, List<String> fieldIds, List<String> fieldLabels, Map<String, String> uniqueIds, Map<String, List<Tuple<String, Double>>> conceptsMap) {
            this.id = id;
            this.label = label;
            this.fieldType = fieldType;
            this.aggregationType = aggregationType;
            this.concepts = concepts;
            this.fieldIds = fieldIds;
            this.fieldLabels = fieldLabels;
            this.uniqueIds = uniqueIds;
            this.conceptsMap = conceptsMap;
        }

        public List<Tuple<String, Double>> getConcepts() {
            return this.concepts;
        }

        public String getId() {
            return this.id;
        }

        public List<String> getFieldIds() {
            return this.fieldIds;
        }

        public List<String> getFieldLabels() {
            return this.fieldLabels;
        }

        public Map<String, String> getUniqueIds() {
            return this.uniqueIds;
        }

        public Map<String, List<Tuple<String, Double>>> getConceptsMap() {
            return this.conceptsMap;
        }

        public String getLabel() {
            return this.label;
        }

        public FieldType getType() {
            return this.fieldType;
        }

        public AggregationType getAggregationType() {
            return this.aggregationType;
        }

        public boolean isCategorical() {
            return this.fieldType == FieldType.CATEGORICAL;
        }
    }

    public static enum Status {
        DEGENERATE,
        BINNED,
        MERGED_CATEGORIES,
        ADDED_MISSING,
        ZERO_INFLATED,
        REPLACED_OUTLIERS,
        ALL_MISSING;

    }
}

