/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.data;

import com.ibm.bi.predict.data.DataFrame;
import com.ibm.bi.predict.math.NumericUtils;
import java.util.Arrays;
import java.util.Optional;

public class FrequencyTable {
    private final int rows;
    private final int cols;
    private final double[][] data;

    public FrequencyTable(int rows, int cols) {
        if (rows <= 0) {
            throw new IllegalArgumentException("Number of rows must be positive");
        }
        if (cols <= 0) {
            throw new IllegalArgumentException("Number of columns must be positive");
        }
        this.rows = rows;
        this.cols = cols;
        this.data = new double[rows][cols];
    }

    public FrequencyTable(double[][] data) {
        if (data == null || data.length == 0 || data[0].length == 0) {
            throw new IllegalArgumentException("Input data array is null or empty");
        }
        this.rows = data.length;
        this.cols = data[0].length;
        this.data = new double[this.rows][];
        for (int r = 0; r < this.rows; ++r) {
            this.data[r] = Arrays.copyOf(data[r], this.cols);
        }
    }

    public final int getNumRows() {
        return this.rows;
    }

    public final int getNumCols() {
        return this.cols;
    }

    public final double[][] getData() {
        return this.data;
    }

    public final void clear() {
        for (int r = 0; r < this.rows; ++r) {
            for (int c = 0; c < this.cols; ++c) {
                this.data[r][c] = 0.0;
            }
        }
    }

    public final void set(int r, int c, double v) {
        this.data[r][c] = v;
    }

    public final void add(int r, int c, double v) {
        double[] dArray = this.data[r];
        int n = c;
        dArray[n] = dArray[n] + v;
    }

    public static FrequencyTable crosstab(DataFrame data, int colM, int colN, int colW, Optional<FrequencyTable> scratch) {
        FrequencyTable result;
        int nFields = data.getNumFields();
        if (colM < 0 || colM >= nFields || colN < 0 || colN >= nFields || colW >= nFields) {
            throw new IllegalArgumentException("Illegal column number");
        }
        int m = data.getFieldCategories(colM);
        int n = data.getFieldCategories(colN);
        if (scratch.isPresent()) {
            result = scratch.get();
            result.clear();
        } else {
            result = new FrequencyTable(m, n);
        }
        int numRows = data.getNumRows();
        for (int row = 0; row < numRows; ++row) {
            double valueW;
            double valueM = data.getValue(colM, row);
            double valueN = data.getValue(colN, row);
            double d = valueW = colW < 0 ? 1.0 : data.getValue(colW, row);
            if (NumericUtils.isMissingValue((double)valueM) || NumericUtils.isMissingValue((double)valueN) || NumericUtils.isMissingValue((double)valueW)) continue;
            result.add((int)valueM, (int)valueN, valueW);
        }
        return result;
    }

    public static FrequencyTable crosstab(DataFrame data, int colM, int colN, int colW) {
        return FrequencyTable.crosstab(data, colM, colN, colW, Optional.empty());
    }

    public static FrequencyTable crosstab(DataFrame data, int colM, int colN) {
        return FrequencyTable.crosstab(data, colM, colN, -1, Optional.empty());
    }

    public static FrequencyTable crosstab(DataFrame data, int colM, int colN, FrequencyTable scratch) {
        return FrequencyTable.crosstab(data, colM, colN, -1, Optional.of(scratch));
    }
}

