/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.data;

import com.ibm.bi.predict.data.Category;
import com.ibm.bi.predict.data.Config;
import com.ibm.bi.predict.data.DataColumn;
import com.ibm.bi.predict.dataaccess.types.FieldType;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import org.apache.commons.lang3.mutable.MutableInt;

public class HandleMissingValuesInPredictors {
    private final boolean applyIfNeeded;
    private static final Logger LOG = PredictLoggerFactory.getLogger(HandleMissingValuesInPredictors.class);

    public HandleMissingValuesInPredictors(Config config) {
        this(config.missingValuesInSeparateCategory());
    }

    public HandleMissingValuesInPredictors(boolean applyIfNeeded) {
        this.applyIfNeeded = applyIfNeeded;
    }

    public DataColumn test(DataColumn column) {
        if (!this.needMissingValueHandling(column)) {
            return column;
        }
        return HandleMissingValuesInPredictors.handleMiss(column);
    }

    private boolean needMissingValueHandling(DataColumn column) {
        return this.applyIfNeeded && column.getType() == FieldType.CATEGORICAL;
    }

    private static DataColumn handleMiss(DataColumn column) {
        MutableInt foundMissing = new MutableInt();
        column.replaceValues(v -> {
            if (Double.isNaN(v)) {
                foundMissing.increment();
                return column.getCategoryCount();
            }
            return v;
        });
        if (foundMissing.intValue() == 0) {
            return column;
        }
        column.addCategory(Category.MISSING);
        column.addStatus(DataColumn.Status.ADDED_MISSING);
        column.getSummaryData().setMissingValuesCount(foundMissing.intValue());
        LOG.debug("Categorical Predictor: " + column.getId() + ", category count: " + column.getCategoryCount() + ", Number of missing: " + foundMissing.intValue());
        return column;
    }
}

