/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.data;

import com.ibm.bi.predict.data.Binner;
import com.ibm.bi.predict.data.Config;
import com.ibm.bi.predict.data.DataColumn;
import com.ibm.bi.predict.dataaccess.types.FieldType;
import com.ibm.bi.predict.math.NumericUtils;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.Arrays;

public class HandleOutliersInTarget {
    private final boolean applyIfNeeded;
    private final double outlierMultiplierConstant;
    private final double outlierPercentile;
    private int outliersCount;
    private static final Logger LOG = PredictLoggerFactory.getLogger(HandleOutliersInTarget.class);

    public HandleOutliersInTarget(Config config) {
        this(config.handleOutliersInTarget(), config.outlierMultiplierConstant(), config.outlierPercentile());
    }

    public HandleOutliersInTarget(boolean applyIfNeeded, double outlierMultiplierConstant, double outlierPercentile) {
        this.applyIfNeeded = applyIfNeeded;
        this.outlierMultiplierConstant = outlierMultiplierConstant;
        this.outlierPercentile = outlierPercentile;
        this.outliersCount = 0;
    }

    public DataColumn test(DataColumn column) {
        if (!this.needOutliersHandlingInTarget(column)) {
            return column;
        }
        return this.handleOutliers(column);
    }

    private boolean needOutliersHandlingInTarget(DataColumn column) {
        return this.applyIfNeeded && column.getType() == FieldType.NUMERICAL;
    }

    private DataColumn handleOutliers(DataColumn column) {
        if (column.rowCount() < 1) {
            column.addStatus(DataColumn.Status.ALL_MISSING);
            return column;
        }
        double[] data = Binner.makeSortedCopy(column);
        double[] lowerUpperBounds = this.detectLowerAndUpperBounds(data);
        double lowerBound = lowerUpperBounds[0];
        double upperBound = lowerUpperBounds[1];
        column.replaceValues(o -> this.replace(o, lowerBound, upperBound));
        if (this.outliersCount == 0) {
            return column;
        }
        LOG.debug("Continuous Target: " + column.getId() + ", Number of Outliers: " + this.outliersCount + ", Adjusted Lower bound: " + lowerBound + ", Adjusted Upper bound: " + upperBound);
        column.addStatus(DataColumn.Status.REPLACED_OUTLIERS);
        column.getSummaryData().setOutliersCount(this.outliersCount);
        column.getSummaryData().setOutlierLowerBound(lowerBound);
        column.getSummaryData().setOutlierUpperBound(upperBound);
        return column;
    }

    private double[] detectLowerAndUpperBounds(double[] data) {
        double[] bounds = new double[2];
        double lowerPercentile = HandleOutliersInTarget.getPercentile(data, this.outlierPercentile);
        double median = HandleOutliersInTarget.getPercentile(data, 0.5);
        double upperPercentile = HandleOutliersInTarget.getPercentile(data, 1.0 - this.outlierPercentile);
        double lowerPercentage = HandleOutliersInTarget.getPercentage(data, lowerPercentile, true);
        double upperPercentage = HandleOutliersInTarget.getPercentage(data, upperPercentile, false);
        lowerPercentile = HandleOutliersInTarget.getPercentile(data, lowerPercentage / 2.0);
        upperPercentile = HandleOutliersInTarget.getPercentile(data, 1.0 - upperPercentage / 2.0);
        bounds[0] = lowerPercentile - this.outlierMultiplierConstant * (median - lowerPercentile);
        bounds[1] = upperPercentile + this.outlierMultiplierConstant * (upperPercentile - median);
        return bounds;
    }

    private double replace(double o, double lcl, double ucl) {
        if (o < lcl) {
            ++this.outliersCount;
            return lcl;
        }
        if (o > ucl) {
            ++this.outliersCount;
            return ucl;
        }
        return o;
    }

    private static double getPercentile(double[] latencies, double percentile) {
        if (NumericUtils.equals((double)percentile, (double)0.0)) {
            return latencies[0];
        }
        int index = (int)Math.ceil(percentile * (double)latencies.length);
        return latencies[index - 1];
    }

    private static double getPercentage(double[] data, double limit, boolean isLower) {
        double count = isLower ? (double)Arrays.stream(data).filter(x -> x < limit).count() : (double)Arrays.stream(data).filter(x -> x > limit).count();
        return count / (double)data.length;
    }
}

