/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.data.matrix;

import com.ibm.bi.predict.data.matrix.CellVisitor;
import com.ibm.bi.predict.data.matrix.DataVector;
import com.ibm.bi.predict.data.matrix.Matrix;
import com.ibm.bi.predict.data.matrix.MatrixVectorFactory;
import com.ibm.bi.predict.math.NumberFormatter;
import com.ibm.bi.predict.math.NumericUtils;
import java.util.ArrayList;
import java.util.Locale;
import java.util.stream.Collectors;

class DataMatrix
implements Matrix {
    private final int rowDimension;
    private final int columnDimension;
    private final DataVector data;
    private double[] rowTotals = null;
    private double[] columnTotals = null;

    static void checkValid(double rowCount, int columnCount) {
        if (rowCount * (double)columnCount > 2.147483647E9) {
            throw new IllegalArgumentException("Matrix is too large -- number of cells must be less than 2147483647");
        }
    }

    static boolean isSparse(double[][] data) {
        if (data.length == 0 || data[0].length == 0) {
            return false;
        }
        int limit = (int)((double)(data.length * data[0].length) * 0.1);
        double[][] dArray = data;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double[] row;
            for (double v : row = dArray[i]) {
                if (NumericUtils.isZero((double)v) || --limit >= 0) continue;
                return false;
            }
        }
        return true;
    }

    DataMatrix(int rowDimension, int columnCount, DataVector data) {
        this.rowDimension = rowDimension;
        this.columnDimension = columnCount;
        this.data = data;
    }

    @Override
    public void add(Matrix m) {
        m.walkAll((row, column, value) -> this.data.increment(this.keyOf(row, column), value));
        this.clearCachedStats();
    }

    @Override
    public int columnDimension() {
        return this.columnDimension;
    }

    @Override
    public double columnTotal(int col) {
        return this.columnTotals()[col];
    }

    @Override
    public double[] columnTotals() {
        if (this.columnTotals == null) {
            this.columnTotals = new double[this.columnDimension()];
            this.walkNonZero((r, c, v) -> {
                int n = c;
                this.columnTotals[n] = this.columnTotals[n] + v;
            });
        }
        return this.columnTotals;
    }

    @Override
    public DataMatrix copy() {
        return new DataMatrix(this.rowDimension, this.columnDimension, this.data.copy());
    }

    @Override
    public int countNonZero() {
        return this.data.countNonZero();
    }

    @Override
    public double[][] getData() {
        double[][] d = new double[this.rowDimension()][this.columnDimension()];
        this.walkNonZero((r, c, v) -> {
            d[r][c] = v;
        });
        return d;
    }

    @Override
    public double[] getDataAsVector() {
        return this.data.getDataVector();
    }

    @Override
    public double getValue(int r, int c) {
        return this.data.getValue(this.keyOf(r, c));
    }

    @Override
    public void increment(int row, int column) {
        this.increment(row, column, 1.0);
    }

    @Override
    public void increment(int row, int column, double value) {
        this.data.increment(this.keyOf(row, column), value);
        this.clearCachedStats();
    }

    @Override
    public boolean isSparse() {
        return this.data.isSparse();
    }

    @Override
    public void modifyNonZero(Matrix.EntryFunction function) {
        this.data.walkNonZero((Integer index, Double v) -> {
            int r = index / this.columnDimension;
            int c = index % this.columnDimension;
            double value = this.data.getValue((int)index);
            this.data.setValue((int)index, function.apply(r, c, value));
        });
        this.clearCachedStats();
    }

    @Override
    public int rowDimension() {
        return this.rowDimension;
    }

    @Override
    public double rowTotal(int row) {
        return this.rowTotals()[row];
    }

    @Override
    public double[] rowTotals() {
        if (this.rowTotals == null) {
            this.rowTotals = new double[this.rowDimension()];
            this.walkNonZero((r, c, v) -> {
                int n = r;
                this.rowTotals[n] = this.rowTotals[n] + v;
            });
        }
        return this.rowTotals;
    }

    @Override
    public void setValue(int r, int c, double v) {
        this.data.unsafeSetValue(this.keyOf(r, c), v);
        this.clearCachedStats();
    }

    @Override
    public double sum() {
        return this.data.sum();
    }

    @Override
    public double sumAll(Matrix.EntryFunction function) {
        return this.walkAll(this.makeSummingVisitor(function));
    }

    @Override
    public double sumNonZero(Matrix.EntryFunction function) {
        return this.walkNonZero(this.makeSummingVisitor(function));
    }

    @Override
    public DataMatrix transpose() {
        DataMatrix transposed = MatrixVectorFactory.makeDataMatrix(this.columnDimension(), this.rowDimension(), this.isSparse());
        this.walkNonZero((r, c, v) -> transposed.unsafeSetValue(c, r, v));
        return transposed;
    }

    @Override
    public double walkAll(CellVisitor visitor) {
        int numRows = this.rowDimension();
        int numCols = this.columnDimension();
        visitor.start(numRows, numCols);
        for (int r = 0; r < numRows; ++r) {
            for (int c = 0; c < numCols; ++c) {
                visitor.visit(r, c, this.getValue(r, c));
            }
        }
        return visitor.end();
    }

    @Override
    public double walkNonZero(CellVisitor visitor) {
        visitor.start(this.rowDimension, this.columnDimension);
        this.data.walkNonZero((Integer index, Double v) -> visitor.visit(index / this.columnDimension, index % this.columnDimension, (double)v));
        return visitor.end();
    }

    @Override
    public boolean isOneByOneMatrix() {
        return this.rowDimension == 1 && this.columnDimension == 1;
    }

    @Override
    public boolean is2DMatrix() {
        return this.rowDimension > 1 && this.columnDimension > 1;
    }

    public int hashCode() {
        return 31 * (31 * this.rowDimension + this.columnDimension) + this.data.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataMatrix)) {
            return false;
        }
        DataMatrix that = (DataMatrix)o;
        if (this.rowDimension != that.rowDimension) {
            return false;
        }
        if (this.columnDimension != that.columnDimension) {
            return false;
        }
        return this.data.equals(that.data);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append('[');
        double nonZeroCount = this.sumNonZero((row, column, value) -> 1.0);
        if (nonZeroCount < 0.5 * (double)this.columnDimension * (double)this.rowDimension) {
            ArrayList values = new ArrayList(this.rowDimension);
            b.append(this.rowDimension).append("x").append(this.columnDimension).append(" -- ");
            this.walkNonZero((i, j, v) -> values.add(String.format("(%d,%d):%s", i, j, NumberFormatter.format((Locale)Locale.US, (boolean)false, (double)v))));
            b.append(values.stream().collect(Collectors.joining(" ")));
        } else {
            for (int r = 0; r < this.rowDimension; ++r) {
                if (r > 0) {
                    b.append(" ");
                }
                b.append('[');
                for (int c = 0; c < this.columnDimension; ++c) {
                    if (c > 0) {
                        b.append(" ");
                    }
                    b.append(NumberFormatter.format((Locale)Locale.US, (boolean)false, (double)this.getValue(r, c)));
                }
                b.append(']');
            }
        }
        b.append(']');
        return b.toString();
    }

    protected void unsafeSetValue(int r, int c, double v) {
        this.data.unsafeSetValue(this.unsafeKeyOf(r, c), v);
    }

    CellVisitor makeSummingVisitor(final Matrix.EntryFunction function) {
        return new CellVisitor(){
            double total = 0.0;

            @Override
            public double end() {
                return this.total;
            }

            @Override
            public void visit(int row, int column, double value) {
                this.total += function.apply(row, column, value);
            }
        };
    }

    private void clearCachedStats() {
        this.columnTotals = null;
        this.rowTotals = null;
    }

    private int keyOf(int r, int c) {
        if (r < 0 || r >= this.rowDimension) {
            throw new ArrayIndexOutOfBoundsException(r);
        }
        if (c < 0 || c >= this.columnDimension) {
            throw new ArrayIndexOutOfBoundsException(c);
        }
        return this.unsafeKeyOf(r, c);
    }

    private int unsafeKeyOf(int r, int c) {
        return r * this.columnDimension + c;
    }
}

