/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.data.matrix;

import com.ibm.bi.predict.data.matrix.Vector;
import com.ibm.bi.predict.math.NumericUtils;
import java.util.HashSet;
import java.util.function.ToDoubleBiFunction;
import org.apache.commons.lang3.mutable.MutableInt;

abstract class DataVector
implements Vector {
    static final double USE_SPARSE_WHEN_LESS_NON_ZEROES = 0.1;
    protected final int length;
    protected CachedStats stats;

    static boolean isSparse(double[] data) {
        int limit = (int)((double)data.length * 0.1);
        for (double v : data) {
            if (NumericUtils.isZero((double)v) || --limit >= 0) continue;
            return false;
        }
        return true;
    }

    protected DataVector(int length) {
        this.length = length;
    }

    public int hashCode() {
        MutableInt hash = new MutableInt(this.length);
        this.walkNonZero((i, v) -> hash.setValue(hash.getValue() * 31 + 7 * i + Double.hashCode(v)));
        return hash.getValue();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataVector)) {
            return false;
        }
        DataVector vector = (DataVector)o;
        if (this.length != vector.length) {
            return false;
        }
        HashSet myNonZero = new HashSet();
        this.walkNonZero((i, v) -> myNonZero.add(i));
        HashSet oNonZero = new HashSet();
        vector.walkNonZero((i, v) -> oNonZero.add(i));
        if (!oNonZero.equals(myNonZero)) {
            return false;
        }
        for (Integer i2 : myNonZero) {
            if (NumericUtils.equals((double)this.getValue(i2), (double)((DataVector)o).getValue(i2))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public void setValue(int index, double value) {
        this.unsafeSetValue(index, value);
        this.stats = null;
    }

    @Override
    public double sum() {
        return this.getCachedStats().sum;
    }

    protected CachedStats getCachedStats() {
        if (this.stats == null) {
            this.stats = new CachedStats();
        }
        return this.stats;
    }

    @Override
    public int countNonZero() {
        return this.getCachedStats().nonZeroCount;
    }

    @Override
    public double sumAll(ToDoubleBiFunction<Integer, Double> function) {
        SummingVisitor visitor = this.makeSummingVisitor(function);
        this.walkAll(visitor::visit);
        return visitor.end();
    }

    @Override
    public double sumNonZero(ToDoubleBiFunction<Integer, Double> function) {
        SummingVisitor visitor = this.makeSummingVisitor(function);
        this.walkNonZero(visitor::visit);
        return visitor.end();
    }

    abstract double[] getDataVector();

    protected abstract void increment(int var1, double var2);

    protected abstract void unsafeSetValue(int var1, double var2);

    SummingVisitor makeSummingVisitor(final ToDoubleBiFunction<Integer, Double> function) {
        return new SummingVisitor(){
            double total = 0.0;

            @Override
            void visit(Integer index, Double value) {
                this.total += function.applyAsDouble(index, value);
            }

            @Override
            double end() {
                return this.total;
            }
        };
    }

    protected final class CachedStats {
        private double sum;
        private int nonZeroCount;

        private CachedStats() {
            DataVector.this.walkNonZero((i, v) -> {
                this.sum += v.doubleValue();
                ++this.nonZeroCount;
            });
        }
    }

    private static abstract class SummingVisitor {
        private double total = 0.0;

        private SummingVisitor() {
        }

        abstract void visit(Integer var1, Double var2);

        double end() {
            return this.total;
        }
    }
}

