/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.data.matrix;

import com.ibm.bi.predict.data.matrix.DataVector;
import com.ibm.bi.predict.math.NumberFormatter;
import com.ibm.bi.predict.math.NumericUtils;
import java.util.Arrays;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

class DataVectorAsArray
extends DataVector {
    private final double[] data;

    DataVectorAsArray(double[] data) {
        super(data.length);
        this.data = data;
    }

    @Override
    public DataVector copy() {
        return new DataVectorAsArray(Arrays.copyOf(this.data, this.data.length));
    }

    @Override
    public double getValue(int index) {
        return this.data[index];
    }

    @Override
    public boolean isSparse() {
        return false;
    }

    @Override
    public void walkAll(BiConsumer<Integer, Double> consumer) {
        for (int i = 0; i < this.length; ++i) {
            consumer.accept(i, this.data[i]);
        }
    }

    @Override
    public void walkNonZero(BiConsumer<Integer, Double> consumer) {
        for (int i = 0; i < this.length; ++i) {
            if (NumericUtils.isZero((double)this.data[i])) continue;
            consumer.accept(i, this.data[i]);
        }
    }

    public double sumNonZero(BiConsumer<Integer, Double> consumer) {
        return 0.0;
    }

    public String toString() {
        return "[" + Arrays.stream(this.data).mapToObj(v -> NumberFormatter.format((Locale)Locale.US, (boolean)false, (double)v)).collect(Collectors.joining(" ")) + "]";
    }

    @Override
    protected void increment(int index, double value) {
        int n = index;
        this.data[n] = this.data[n] + value;
        this.stats = null;
    }

    @Override
    public void unsafeSetValue(int index, double value) {
        this.data[index] = value;
    }

    @Override
    public double[] getDataVector() {
        return this.data;
    }
}

