/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.data.matrix;

import com.ibm.bi.predict.data.matrix.DataMatrix;
import com.ibm.bi.predict.data.matrix.DataVector;
import com.ibm.bi.predict.data.matrix.DataVectorAsArray;
import com.ibm.bi.predict.data.matrix.DataVectorAsMap;
import com.ibm.bi.predict.data.matrix.Matrix;
import com.ibm.bi.predict.math.NumericUtils;

public class MatrixVectorFactory {
    private MatrixVectorFactory() {
    }

    public static Matrix makeMatrix(int rowCount, int columnCount, int expectedEntryCount) {
        boolean sparse = (double)expectedEntryCount < 0.1 * (double)rowCount * (double)columnCount;
        return MatrixVectorFactory.makeMatrix(rowCount, columnCount, sparse);
    }

    public static Matrix makeMatrix(int rowCount, int columnCount, boolean sparse) {
        DataMatrix.checkValid(rowCount, columnCount);
        DataVector base = MatrixVectorFactory.makeVector(rowCount * columnCount, sparse);
        return new DataMatrix(rowCount, columnCount, base);
    }

    public static DataVector makeVector(int length, boolean sparse) {
        return sparse ? new DataVectorAsMap(length) : new DataVectorAsArray(new double[length]);
    }

    public static DataVector makeVector(int length, int expectedEntryCount) {
        boolean sparse = (double)expectedEntryCount < 0.1 * (double)length;
        return MatrixVectorFactory.makeVector(length, sparse);
    }

    public static DataVector vectorFromData(double[] data) {
        return MatrixVectorFactory.vectorFromData(data, DataVector.isSparse(data));
    }

    public static DataVector vectorFromData(double[] data, boolean sparse) {
        return sparse ? new DataVectorAsMap(data) : new DataVectorAsArray(data);
    }

    public static Matrix matrixFromData(double[][] data) {
        return MatrixVectorFactory.matrixFromData(data, DataMatrix.isSparse(data));
    }

    public static Matrix matrixFromData(double[][] data, boolean sparse) {
        int rowCount = data.length;
        int columnCount = data.length > 0 ? data[0].length : 0;
        DataMatrix matrix = MatrixVectorFactory.makeDataMatrix(rowCount, columnCount, sparse);
        for (int r = 0; r < rowCount; ++r) {
            double[] row = data[r];
            for (int c = 0; c < columnCount; ++c) {
                if (NumericUtils.isZero((double)row[c])) continue;
                matrix.unsafeSetValue(r, c, row[c]);
            }
        }
        return matrix;
    }

    static DataMatrix makeDataMatrix(int rowCount, int columnCount, boolean isSparse) {
        DataVector base = MatrixVectorFactory.makeVector(rowCount * columnCount, isSparse);
        return new DataMatrix(rowCount, columnCount, base);
    }
}

