/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.data.store;

import com.ibm.bi.predict.data.store.ByteArray;
import com.ibm.bi.predict.data.store.DoubleArray;
import com.ibm.bi.predict.data.store.FloatArray;
import com.ibm.bi.predict.math.NumberFormatter;
import java.util.Locale;
import java.util.PrimitiveIterator;
import java.util.function.DoubleFunction;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;

public abstract class DataArray
implements Iterable<Double> {
    private static final int MAX_ITEMS_FOR_TOSTRING = 5;
    private final int size;

    public static DataArray of(double[] data) {
        if (data == null) {
            return null;
        }
        boolean canBeBytes = true;
        boolean canBeFloat = true;
        for (double v : data) {
            if (Double.isFinite(v)) {
                if (v > 3.4028234663852886E38 || v < -3.4028234663852886E38) {
                    canBeBytes = false;
                    canBeFloat = false;
                    break;
                }
                if (!canBeBytes || v % 1.0 == 0.0 && !(v <= -128.0) && !(v > 127.0)) continue;
                canBeBytes = false;
                continue;
            }
            if (!Double.isInfinite(v)) continue;
            canBeBytes = false;
        }
        if (canBeBytes) {
            return ByteArray.fromDoubles(data);
        }
        if (canBeFloat) {
            return FloatArray.fromDoubles(data);
        }
        return DoubleArray.fromDoubles(data);
    }

    protected DataArray(int length) {
        this.size = length;
    }

    public PrimitiveIterator.OfDouble iterator() {
        return new ArrayIterator();
    }

    public int size() {
        return this.size;
    }

    public final DoubleStream stream() {
        return IntStream.range(0, this.size).mapToDouble(this::value);
    }

    public String toString() {
        DoubleFunction<String> formatDouble = v -> NumberFormatter.format((Locale)Locale.US, (boolean)false, (double)v);
        String base = this.stream().limit(5L).mapToObj(formatDouble).collect(Collectors.joining(", "));
        if (this.size() > 5) {
            base = base + " .. " + formatDouble.apply(this.value(this.size - 1));
        }
        return "[" + base + "]";
    }

    public abstract double value(int var1);

    private class ArrayIterator
    implements PrimitiveIterator.OfDouble {
        private int at = 0;

        private ArrayIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.at < DataArray.this.size();
        }

        @Override
        public double nextDouble() {
            return DataArray.this.value(this.at++);
        }
    }
}

