/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.dataaccess.endorv2;

import com.ibm.bi.predict.dataaccess.MetaData;
import com.ibm.bi.predict.dataaccess.endorv2.V2Column;
import com.ibm.bi.predict.dataaccess.endorv2.V2Field;
import com.ibm.bi.predict.dataaccess.endorv2.V2Identifier;
import com.ibm.bi.predict.dataaccess.endorv2.V2Item;
import com.ibm.bi.predict.dataaccess.json.JsonHelpers;
import com.ibm.bi.predict.dataaccess.types.AggregationType;
import com.ibm.bi.predict.dataaccess.types.FieldType;
import com.ibm.bi.predict.dataaccess.types.StatisticStatus;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import com.ibm.bi.predict.utils.Tuple;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.json.JSONObject;

public class V2MetaData
implements MetaData {
    private static final Logger log = PredictLoggerFactory.getLogger(V2MetaData.class);
    public static final String ROW_COUNT = "rowCount";
    public static final String SUM_SQR = "sumSqr";
    private final int rowCount;
    private final JSONObject params;
    private final List<V2Column> columns;

    public V2MetaData(int rowCount, JSONObject params, List<V2Column> columns) {
        this.rowCount = rowCount;
        this.params = params;
        this.columns = columns;
    }

    @Override
    public int rowCount() {
        return this.rowCount;
    }

    @Override
    public int fieldCount() {
        return this.columns.size();
    }

    @Override
    public String getFieldIdentifier(int columnIndex) {
        V2Column column = this.columns.get(columnIndex);
        if (column.numFields() != 1) {
            log.warn("Trying to get single aggregation of stacked field - numStacked={}", (Object)column.numFields());
        }
        return column.fields().get(0).id();
    }

    @Override
    public List<String> getFieldIdentifiers(int columnIndex) {
        return this.columns.get(columnIndex).fields().stream().map(V2Field::id).collect(Collectors.toList());
    }

    @Override
    public String getFieldDisplayLabel(int columnIndex) {
        return this.columns.get(columnIndex).fields().stream().map(field -> field.label()).collect(Collectors.joining(" - "));
    }

    @Override
    public FieldType getFieldType(int columnIndex) {
        List<V2Field> fields = this.columns.get(columnIndex).fields();
        boolean allCategorical = fields.stream().allMatch(field -> field.aggregation() == AggregationType.NONE);
        if (allCategorical) {
            return FieldType.CATEGORICAL;
        }
        return FieldType.NUMERICAL;
    }

    @Override
    public int getFieldCategories(int columnIndex) {
        V2Column column = this.columns.get(columnIndex);
        return column.categories().size();
    }

    @Override
    public StatisticStatus getStatisticStatus(String statisticName, int columnIndex) {
        String statId = statisticName + ":" + this.getFieldIdentifier(columnIndex);
        for (V2Column column : this.columns) {
            for (V2Field field : column.fields()) {
                if (!field.id().equals(statId)) continue;
                return StatisticStatus.AVAILABLE;
            }
        }
        return StatisticStatus.UNAVAILABLE;
    }

    @Override
    public List<String> getFieldDisplayLabels(int columnIndex) {
        return this.columns.get(columnIndex).fields().stream().map(V2Field::label).collect(Collectors.toList());
    }

    @Override
    public List<Tuple<String, Double>> getConcepts(int columnIndex) {
        return Collections.emptyList();
    }

    @Override
    public Map<String, List<Tuple<String, Double>>> getConceptsMap() {
        return Collections.emptyMap();
    }

    @Override
    public Map<String, String> getUniqueIdentifiersMap(int columnIndex) {
        return this.columns.get(columnIndex).fields().stream().collect(Collectors.toMap(V2Field::id, V2Field::id));
    }

    @Override
    public List<String> getFieldCategoryLabels(int columnIndex, int categoryIndex) {
        List<V2Item> itemsForItemClass = this.columns.get(columnIndex).categories();
        return itemsForItemClass.get(categoryIndex).ids().stream().map(V2Identifier::label).collect(Collectors.toList());
    }

    @Override
    public String getFieldCategoryLabel(int columnIndex, int categoryIndex) {
        return String.join((CharSequence)"|", this.getFieldCategoryLabels(columnIndex, categoryIndex));
    }

    @Override
    public String getFieldCategoryIdentifier(int columnIndex, int categoryIndex) {
        List<String> ids = this.getFieldCategoryIdentifiers(columnIndex, categoryIndex);
        if (ids.size() != 1) {
            throw new IllegalStateException("Expected item to have one valid category. Found " + ids.size());
        }
        return ids.get(0);
    }

    @Override
    public List<String> getFieldCategoryIdentifiers(int columnIndex, int categoryIndex) {
        List<V2Item> itemsForItemClass = this.columns.get(columnIndex).categories();
        return itemsForItemClass.get(categoryIndex).ids().stream().map(V2Identifier::uniqueId).collect(Collectors.toList());
    }

    @Override
    public AggregationType getFieldAggregation(int columnIndex) {
        if (this.itemsInField(columnIndex) != 1) {
            log.warn("Trying to get single aggregation of stacked field - numStacked={}", (Object)this.itemsInField(columnIndex));
        }
        return this.columns.get(columnIndex).fields().get(0).aggregation();
    }

    @Override
    public List<AggregationType> getFieldCategoryAggregations(int columnIndex, int categoryIndex) {
        return this.columns.get(columnIndex).fields().stream().map(V2Field::aggregation).collect(Collectors.toList());
    }

    @Override
    public boolean isClippedData() {
        if (this.params.containsKey((Object)"hasNext")) {
            return JsonHelpers.getBoolean(this.params, "hasNext");
        }
        return false;
    }

    @Override
    public int itemsInField(int columnIndex) {
        return this.columns.get(columnIndex).numFields();
    }
}

