/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.dataaccess.json;

import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import com.ibm.bi.predict.utils.Tuple;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class JsonConceptParser {
    private static final Logger LOGGER = PredictLoggerFactory.getLogger(JsonConceptParser.class);

    JsonConceptParser() {
    }

    public static Map<String, Map<String, List<Tuple<String, Double>>>> parseConcepts(JSONObject request) {
        try {
            HashMap<String, Map<String, List<Tuple<String, Double>>>> result = new HashMap<String, Map<String, List<Tuple<String, Double>>>>();
            JSONArray concepts = request.getJSONArray("concepts");
            for (int i = 0; i < concepts.size(); ++i) {
                JSONObject datasetConcepts = concepts.getJSONObject(i);
                String datasetId = datasetConcepts.getString("datasetId");
                Map<String, List<Tuple<String, Double>>> conceptMap = JsonConceptParser.parseConceptColumns(datasetConcepts.getJSONArray("columns"));
                result.put(datasetId, conceptMap);
            }
            return result;
        }
        catch (JSONException e) {
            LOGGER.debug("Exception parsing concepts, an empty map will be used");
            return Collections.emptyMap();
        }
    }

    private static Map<String, List<Tuple<String, Double>>> parseConceptColumns(JSONArray columns) throws JSONException {
        HashMap<String, List<Tuple<String, Double>>> result = new HashMap<String, List<Tuple<String, Double>>>();
        for (int i = 0; i < columns.size(); ++i) {
            result.putAll(JsonConceptParser.parseConceptColumn(columns.getJSONObject(i)));
        }
        return result;
    }

    private static Map<String, List<Tuple<String, Double>>> parseConceptColumn(JSONObject column) throws JSONException {
        HashMap<String, List<Tuple<String, Double>>> result = new HashMap<String, List<Tuple<String, Double>>>();
        for (Object keyObj : column.keySet()) {
            String key = keyObj.toString();
            JSONArray conceptsArray = column.getJSONArray(key);
            ArrayList<Tuple> concepts = new ArrayList<Tuple>();
            for (int i = 0; i < conceptsArray.size(); ++i) {
                Tuple conceptDetails = Tuple.of((Object)conceptsArray.getJSONObject(i).getString("conceptID"), (Object)conceptsArray.getJSONObject(i).getDouble("confidence"));
                concepts.add(conceptDetails);
            }
            result.put(key, concepts);
        }
        return result;
    }
}

