/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.dataaccess.json;

import com.ibm.bi.predict.dataaccess.exception.IllegalDataAccessRequest;
import com.ibm.bi.predict.exceptions.PredictException;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import com.ibm.bi.predict.utils.Tuple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.json.JSON;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;
import org.apache.commons.json.OrderedJSONObject;

public class JsonHelpers {
    private static final Logger logger = PredictLoggerFactory.getLogger(JsonHelpers.class);

    private JsonHelpers() {
    }

    public static JSONObject makeDataObj(Object ... items) {
        try {
            JSONObject data = new JSONObject();
            JSONArray arr = new JSONArray();
            arr.addAll(Arrays.asList(items));
            data.put("pt", (Collection)arr);
            return data;
        }
        catch (JSONException e) {
            throw new IllegalDataAccessRequest("Attempting to use null key or non-finite value", e);
        }
    }

    public static JSONObject makeDataItem(JSONObject itemClass, JSONArray items) {
        try {
            JSONObject data = new JSONObject();
            data.put("itemClass", (Map)itemClass);
            if (items != null) {
                data.put("items", (Collection)items);
            }
            return data;
        }
        catch (JSONException e) {
            throw new IllegalDataAccessRequest("Attempting to use non-finite value", e);
        }
    }

    public static JSONObject makeDataItemObject(String[] labels, String[] uniqueIds) {
        JSONArray dataItemArray = new JSONArray();
        for (int i = 0; i < labels.length; ++i) {
            JSONObject dataItemValue = JsonHelpers.makeObj("d", (Object)labels[i], "u", (Object)uniqueIds[i]);
            dataItemArray.add((Object)dataItemValue);
        }
        return JsonHelpers.makeObj("t", (Object)dataItemArray);
    }

    public static JSONObject makeItemClass(JSONObject item, String id) {
        try {
            JSONObject data = new JSONObject();
            data.put("h", Arrays.asList(item));
            data.put("id", (Object)id);
            return data;
        }
        catch (JSONException e) {
            throw new IllegalDataAccessRequest("Attempting to use non-finite value", e);
        }
    }

    public static JSONObject makeItemClass(String id, JSONObject ... items) {
        try {
            JSONObject data = new JSONObject();
            data.put("h", Arrays.asList(items));
            data.put("id", (Object)id);
            return data;
        }
        catch (JSONException e) {
            throw new IllegalDataAccessRequest("JSONException thrown while building itemClass object", e);
        }
    }

    public static JSONObject makeObj() {
        return new JSONObject();
    }

    public static JSONObject makeObj(String key, Object val) {
        try {
            JSONObject data = new JSONObject();
            data.put(key, val);
            return data;
        }
        catch (JSONException e) {
            throw new IllegalDataAccessRequest("Attempting to use null key or non-finite value", e);
        }
    }

    public static JSONArray makeArr(Object ... items) {
        JSONArray arr = new JSONArray();
        arr.addAll(Arrays.asList(items));
        return arr;
    }

    public static JSONObject makeObj(String key1, Object val1, String key2, Object val2) {
        try {
            JSONObject data = new JSONObject();
            data.put(key1, val1);
            data.put(key2, val2);
            return data;
        }
        catch (JSONException e) {
            throw new IllegalDataAccessRequest("Attempting to use null keys or non-finite values", e);
        }
    }

    public static JSONObject makeObj(String key1, Object val1, String key2, Object val2, String key3, Object val3) {
        try {
            JSONObject data = new JSONObject();
            data.put(key1, val1);
            data.put(key2, val2);
            data.put(key3, val3);
            return data;
        }
        catch (JSONException e) {
            throw new IllegalDataAccessRequest("Attempting to use null keys or non-finite values", e);
        }
    }

    public static JSONObject makeObj(String key1, Object val1, String key2, Object val2, String key3, Object val3, String key4, Object val4) {
        try {
            JSONObject data = new JSONObject();
            data.put(key1, val1);
            data.put(key2, val2);
            data.put(key3, val3);
            data.put(key4, val4);
            return data;
        }
        catch (JSONException e) {
            throw new IllegalDataAccessRequest("Attempting to use null keys or non-finite values", e);
        }
    }

    public static JSONObject makeObj(Object ... vals) {
        if (vals.length % 2 != 0) {
            throw new IllegalArgumentException("Invalid number of arguments. Must have values for all keys");
        }
        try {
            JSONObject data = new JSONObject();
            for (int i = 0; i < vals.length; i += 2) {
                data.put(vals[i].toString(), vals[i + 1]);
            }
            return data;
        }
        catch (JSONException e) {
            throw new IllegalDataAccessRequest("Attempting to use null keys or non-finite values", e);
        }
    }

    public static JSONObject makeObj(String str) {
        try {
            return (JSONObject)JSON.parse((String)str);
        }
        catch (JSONException e) {
            throw new IllegalDataAccessRequest("Error while parsing json string - reason=" + e.getMessage(), e);
        }
    }

    public static JSONObject makeOrderedObj(Object ... vals) {
        if (vals.length % 2 != 0) {
            throw new IllegalArgumentException("Invalid number of arguments. Must have values for all keys");
        }
        try {
            OrderedJSONObject data = new OrderedJSONObject();
            for (int i = 0; i < vals.length; i += 2) {
                data.put(vals[i].toString(), vals[i + 1]);
            }
            return data;
        }
        catch (JSONException e) {
            throw new IllegalDataAccessRequest("Attempting to use null keys or non-finite values", e);
        }
    }

    public static List<String> getStringList(JSONObject obj, String id) {
        try {
            JSONArray arr = obj.getJSONArray(id);
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < arr.size(); ++i) {
                list.add(arr.getString(i));
            }
            return list;
        }
        catch (JSONException e) {
            throw new PredictException("Error while getting JSON array - reason=" + e.getMessage(), (Throwable)e);
        }
    }

    public static List<String> optStringList(JSONObject obj, String id) {
        try {
            JSONArray arr = obj.getJSONArray(id);
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < arr.size(); ++i) {
                list.add(arr.getString(i));
            }
            return list;
        }
        catch (JSONException e) {
            logger.warn("Error while getting JSON array - reason={}", (Object)e.getMessage(), (Object)e);
            return Collections.emptyList();
        }
    }

    public static Set<String> getStringSet(JSONObject obj, String id) {
        try {
            JSONArray arr = obj.getJSONArray(id);
            HashSet<String> set = new HashSet<String>();
            for (int i = 0; i < arr.size(); ++i) {
                set.add(arr.getString(i));
            }
            return set;
        }
        catch (JSONException e) {
            throw new PredictException("Error while getting JSON array - reason=" + e.getMessage(), (Throwable)e);
        }
    }

    public static List<Integer> getIntList(JSONObject obj, String id) {
        try {
            JSONArray arr = obj.getJSONArray(id);
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (int i = 0; i < arr.size(); ++i) {
                list.add(arr.getInt(i));
            }
            return list;
        }
        catch (JSONException e) {
            throw new PredictException("Error while getting JSON array - reason=" + e.getMessage(), (Throwable)e);
        }
    }

    public static double getDouble(JSONObject obj, String id) {
        try {
            return obj.getDouble(id);
        }
        catch (JSONException e) {
            throw new PredictException("Error while getting JSON double - reason=" + e.getMessage(), (Throwable)e);
        }
    }

    public static boolean getBoolean(JSONObject obj, String id) {
        try {
            return obj.getBoolean(id);
        }
        catch (JSONException e) {
            throw new PredictException("Error while getting JSON boolean - reason=" + e.getMessage(), (Throwable)e);
        }
    }

    public static List<Double> getDoubleList(JSONObject obj, String id) {
        try {
            JSONArray arr = obj.getJSONArray(id);
            ArrayList<Double> list = new ArrayList<Double>();
            for (int i = 0; i < arr.size(); ++i) {
                if (arr.get(i) == null) {
                    list.add(Double.NaN);
                    continue;
                }
                list.add(arr.getDouble(i));
            }
            return list;
        }
        catch (JSONException e) {
            throw new PredictException("Error while getting JSON array - reason=" + e.getMessage(), (Throwable)e);
        }
    }

    public static JSONObject getObject(JSONObject obj, String id) {
        try {
            return obj.getJSONObject(id);
        }
        catch (JSONException e) {
            throw new PredictException("Error while getting JSON object - reason=" + e.getMessage(), (Throwable)e);
        }
    }

    public static JSONArray getArray(JSONObject obj, String id) {
        try {
            return obj.getJSONArray(id);
        }
        catch (JSONException e) {
            throw new PredictException("Error while getting JSON array - reason=" + e.getMessage(), (Throwable)e);
        }
    }

    public static JSONObject getObjFromArray(JSONArray arr, int idx) {
        try {
            return arr.getJSONObject(idx);
        }
        catch (JSONException e) {
            throw new PredictException("Error while getting JSON object at index - index=" + idx + " reason=" + e.getMessage(), (Throwable)e);
        }
    }

    public static OrderedJSONObject getOrderedObject(JSONObject obj, String id) {
        try {
            return (OrderedJSONObject)obj.getJSONObject(id);
        }
        catch (JSONException e) {
            throw new PredictException("Error while getting JSON object - reason=" + e.getMessage(), (Throwable)e);
        }
    }

    public static String getString(JSONObject obj, String id) {
        try {
            return obj.getString(id);
        }
        catch (JSONException e) {
            throw new PredictException("Error while getting JSON string - reason=" + e.getMessage(), (Throwable)e);
        }
    }

    public static String getString(JSONArray array, int idx) {
        try {
            return array.getString(idx);
        }
        catch (JSONException e) {
            throw new PredictException("Error while getting JSON string - reason=" + e.getMessage(), (Throwable)e);
        }
    }

    public static int getInt(JSONObject obj, String id) {
        try {
            return obj.getInt(id);
        }
        catch (JSONException e) {
            throw new PredictException("Error while getting JSON integer - reason=" + e.getMessage(), (Throwable)e);
        }
    }

    public static int getInt(JSONArray array, int idx) {
        try {
            return array.getInt(idx);
        }
        catch (JSONException e) {
            throw new PredictException("Error while getting JSON integer - reason=" + e.getMessage(), (Throwable)e);
        }
    }

    public static Optional<String> optString(JSONObject obj, String id) {
        try {
            return Optional.ofNullable(obj.getString(id));
        }
        catch (JSONException e) {
            return Optional.empty();
        }
    }

    public static boolean hasArrayKey(JSONObject obj, String id) {
        return JsonHelpers.hasKeyOfType(obj, id, JSONArray.class);
    }

    public static boolean hasObjectKey(JSONObject obj, String id) {
        return JsonHelpers.hasKeyOfType(obj, id, JSONObject.class);
    }

    public static boolean hasStringKey(JSONObject obj, String id) {
        return JsonHelpers.hasKeyOfType(obj, id, String.class);
    }

    public static List<String> keys(JSONObject obj) {
        JSONArray names = obj.names();
        try {
            ArrayList<String> keys = new ArrayList<String>();
            for (int i = 0; i < names.size(); ++i) {
                keys.add(names.getString(i));
            }
            return keys;
        }
        catch (JSONException e) {
            throw new PredictException("Error while getting keys of JSON object - reason=" + e.getMessage(), (Throwable)e);
        }
    }

    private static boolean hasKeyOfType(JSONObject obj, String id, Class<?> type) {
        if (!obj.containsKey((Object)id)) {
            return false;
        }
        try {
            return type.isInstance(obj.get(id));
        }
        catch (JSONException e) {
            return false;
        }
    }

    public static List<Tuple<Integer, Double>> getKeyValueTuples(JSONObject obj, String id) {
        try {
            if (JsonHelpers.hasArrayKey(obj, id)) {
                List<Double> values = JsonHelpers.getDoubleList(obj, id);
                return IntStream.range(0, values.size()).mapToObj(i -> Tuple.of((Object)i, values.get(i))).collect(Collectors.toList());
            }
            JSONObject valueObject = JsonHelpers.getObject(obj, id);
            ArrayList<Tuple<Integer, Double>> list = new ArrayList<Tuple<Integer, Double>>();
            Iterator it = valueObject.keys();
            while (it.hasNext()) {
                String key = (String)it.next();
                Object value = valueObject.get(key);
                list.add((Tuple<Integer, Double>)Tuple.of((Object)Integer.valueOf(key), (Object)(value == null ? Double.NaN : valueObject.getDouble(key))));
            }
            return list;
        }
        catch (JSONException e) {
            throw new PredictException(String.format("Error while getting (key, value) tuples- reason=%s", e.getMessage()), (Throwable)e);
        }
    }

    public static Stream<JSONObject> streamObjects(JSONArray arr) {
        Iterator iter = arr.iterator();
        return Stream.generate(() -> (JSONObject)iter.next()).limit(arr.size());
    }
}

