/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.dataaccess.jsonstat;

import com.ibm.bi.predict.dataaccess.DataAccessProvider;
import com.ibm.bi.predict.dataaccess.DataIterator;
import com.ibm.bi.predict.dataaccess.Decorator;
import com.ibm.bi.predict.dataaccess.jsonstat.JsonStatDataIterator;
import com.ibm.bi.predict.dataaccess.jsonstat.JsonStatDimension;
import com.ibm.bi.predict.dataaccess.jsonstat.JsonStatField;
import com.ibm.bi.predict.dataaccess.jsonstat.JsonStatMetaData;
import com.ibm.bi.predict.dataaccess.jsonstat.JsonStatSeriesHierarchy;
import com.ibm.bi.predict.dataaccess.jsonstat.JsonStatTime;
import com.ibm.bi.predict.dataaccess.types.FieldType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class JsonStatDataAccessProvider
implements DataAccessProvider {
    private double[] data;
    private JsonStatMetaData metadata;
    private JsonStatDimension[] timeDims;
    private JsonStatDimension[] seriesDims;

    public JsonStatDataAccessProvider(double[] data, JsonStatTime time, JsonStatSeriesHierarchy seriesHierarchy) {
        this.data = data;
        this.timeDims = time.getDimensions();
        this.seriesDims = seriesHierarchy.getDims();
        this.metadata = this.buildMetaData();
    }

    private JsonStatMetaData buildMetaData() {
        ArrayList<JsonStatField> fields = new ArrayList<JsonStatField>();
        int columnIndex = JsonStatDataAccessProvider.addFields(fields, this.timeDims, 0, FieldType.CATEGORICAL);
        columnIndex += JsonStatDataAccessProvider.addFields(fields, this.seriesDims, columnIndex, FieldType.CATEGORICAL);
        fields.add(new JsonStatField(columnIndex, "_metric_values_", FieldType.NUMERICAL, null));
        return new JsonStatMetaData(this.getRowCount(), fields);
    }

    @Override
    public JsonStatMetaData getMetaData() {
        return this.metadata;
    }

    @Override
    public DataIterator getDataIterator() {
        int[] timeDimSizes = Arrays.stream(this.timeDims).mapToInt(d -> d.getCategories().length).toArray();
        int[] seriesDimSizes = Arrays.stream(this.seriesDims).mapToInt(d -> d.getCategories().length).toArray();
        return new JsonStatDataIterator(this.data, timeDimSizes, seriesDimSizes);
    }

    @Override
    public Decorator getDecorator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        this.data = null;
        this.metadata = null;
        this.timeDims = null;
        this.seriesDims = null;
    }

    public boolean isReleased() {
        return this.data == null && this.metadata == null && this.timeDims == null && this.seriesDims == null;
    }

    private int getRowCount() {
        return JsonStatDataAccessProvider.getDimsWeight(this.timeDims) * JsonStatDataAccessProvider.getDimsWeight(this.seriesDims);
    }

    private static int getDimsWeight(JsonStatDimension[] dims) {
        int weight = 1;
        for (int fieldIndex = 0; fieldIndex < dims.length; ++fieldIndex) {
            weight *= dims[fieldIndex].getCategories().length;
        }
        return weight;
    }

    public static int addFields(List<JsonStatField> fields, JsonStatDimension[] dims, int startingColumn, FieldType type) {
        int columnIdx = startingColumn;
        for (int fieldIndex = 0; fieldIndex < dims.length; ++fieldIndex) {
            fields.add(new JsonStatField(columnIdx++, dims[fieldIndex].getId(), type, dims[fieldIndex].getCategories()));
        }
        return dims.length;
    }
}

