/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.dataaccess.jsonstat;

import com.ibm.bi.predict.dataaccess.DataIterator;
import com.ibm.bi.predict.dataaccess.jsonstat.JsonStatDataRow;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.stream.IntStream;

public class JsonStatDataIterator
implements DataIterator {
    private double[] data;
    private int[] fieldSize;
    private int[] fieldIncrement;
    private int pos;

    public JsonStatDataIterator(double[] data, int[] timeDimSizes, int[] seriesDimSizes) {
        this.data = data;
        this.fieldSize = IntStream.concat(Arrays.stream(timeDimSizes), Arrays.stream(seriesDimSizes)).toArray();
        this.fieldIncrement = new int[this.fieldSize.length];
        for (int fieldIndex = 0; fieldIndex < this.fieldSize.length; ++fieldIndex) {
            this.fieldIncrement[fieldIndex] = 1;
            for (int j = fieldIndex + 1; j < this.fieldSize.length; ++j) {
                int n = fieldIndex;
                this.fieldIncrement[n] = this.fieldIncrement[n] * this.fieldSize[j];
            }
        }
        this.pos = 0;
    }

    @Override
    public void reset() {
        this.pos = 0;
    }

    @Override
    public boolean hasNext() {
        return this.pos < this.data.length;
    }

    @Override
    public JsonStatDataRow next() {
        double[] values = new double[this.fieldSize.length + 1];
        if (this.pos < this.data.length) {
            int columnIndex = 0;
            int remainder = this.pos;
            for (int fieldIndex = 0; fieldIndex < this.fieldSize.length; ++fieldIndex) {
                values[columnIndex] = remainder / this.fieldIncrement[fieldIndex];
                remainder %= this.fieldIncrement[fieldIndex];
                ++columnIndex;
            }
            values[columnIndex] = this.data[this.pos++];
            return new JsonStatDataRow(values);
        }
        throw new NoSuchElementException();
    }
}

