/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.dataaccess.wrappers;

import com.google.common.collect.BiMap;
import com.ibm.bi.predict.dataaccess.DataRow;
import com.ibm.bi.predict.source.DataSource;
import com.ibm.bi.predict.source.Row;
import com.ibm.bi.predict.utils.Tuple;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;

public class DataSourceWrappedAsDataRow
implements DataRow {
    private final Row row;
    private final DataSource source;
    private final Map<Tuple<String, Integer>, Integer> statsMap;
    private final Map<Integer, BiMap<Double, List<Double>>> groupMappings;
    private double[] convertedValues;

    public DataSourceWrappedAsDataRow(Row row, DataSource source, Map<Tuple<String, Integer>, Integer> statsMap, Map<Integer, BiMap<Double, List<Double>>> groupMappings) {
        this.row = row;
        this.source = source;
        this.statsMap = statsMap;
        this.groupMappings = groupMappings;
        this.convertedValues = this.convertRowValues(row);
    }

    @Override
    public double getValue(int columnIndex) {
        return this.convertedValues[columnIndex];
    }

    private double[] convertRowValues(Row row) {
        int groups = this.source.groups().size();
        int[] columnsPerGroup = this.getColumnsPerGroup(groups);
        double[] convertedValues = new double[groups];
        int rowIndex = 0;
        for (int i = 0; i < groups; ++i) {
            ArrayList<Double> listValues = new ArrayList<Double>();
            if (columnsPerGroup[i] > 1) {
                for (int j = 0; j < columnsPerGroup[i]; ++j) {
                    listValues.add(row.valueAt(rowIndex + j));
                }
            } else {
                listValues.add(row.valueAt(rowIndex));
            }
            BiMap<Double, List<Double>> currGroupMap = this.groupMappings.get(i);
            BiMap inverseMap = currGroupMap.inverse();
            convertedValues[i] = (Double)inverseMap.get(listValues);
            rowIndex += columnsPerGroup[i];
        }
        return convertedValues;
    }

    private int[] getColumnsPerGroup(int groups) {
        int[] columnsPerGroup = new int[groups];
        IntStream.range(0, groups).forEach(i -> {
            columnsPerGroup[i] = this.source.groups().get(i).columns().size();
        });
        return columnsPerGroup;
    }

    @Override
    public double getStatistic(String statisticName, int columnIndex) {
        Tuple key = Tuple.of((Object)statisticName, (Object)columnIndex);
        if (this.statsMap.containsKey(key)) {
            int statsIndex = this.statsMap.get(key);
            return this.row.valueAt(statsIndex);
        }
        return 0.0;
    }
}

