/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.source;

import com.ibm.bi.predict.exceptions.BadParametersException;
import java.util.Objects;
import org.apache.commons.lang3.builder.EqualsBuilder;

public class ColumnFormat {
    private static final ColumnFormat NO_FORMAT = new ColumnFormat(0, "", SymbolPosition.start, null);
    private final int decimals;
    private final String symbol;
    private final SymbolPosition position;
    private final String dateTimePattern;

    public static ColumnFormat formatForString() {
        return NO_FORMAT;
    }

    public static ColumnFormat formatForNumber(int decimals, String symbol, SymbolPosition position) {
        return new ColumnFormat(decimals, symbol, position, null);
    }

    public static ColumnFormat formatForDate(String dateTimePattern) {
        return new ColumnFormat(ColumnFormat.NO_FORMAT.decimals, ColumnFormat.NO_FORMAT.symbol, ColumnFormat.NO_FORMAT.position, dateTimePattern);
    }

    private ColumnFormat(int decimals, String symbol, SymbolPosition position, String dateTimePattern) {
        this.decimals = decimals;
        this.symbol = symbol;
        this.position = position;
        this.dateTimePattern = dateTimePattern;
        if (symbol == null != (position == null)) {
            throw new BadParametersException("Either both or neither of symbol and position must be defined");
        }
    }

    public String dateTimePattern() {
        return this.dateTimePattern;
    }

    public int decimals() {
        return this.decimals;
    }

    public SymbolPosition position() {
        return this.position;
    }

    public String symbol() {
        return this.symbol;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ColumnFormat{");
        sb.append("decimals=").append(this.decimals);
        if (this.symbol != null) {
            sb.append(", symbol='").append(this.symbol).append('\'');
            sb.append('@').append((Object)this.position);
        }
        if (this.dateTimePattern != null) {
            sb.append(", dateTimePattern='").append(this.dateTimePattern).append('\'');
        }
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ColumnFormat)) {
            return false;
        }
        ColumnFormat other = (ColumnFormat)obj;
        return new EqualsBuilder().append(this.decimals, other.decimals).append((Object)this.symbol, (Object)other.symbol).append((Object)this.position, (Object)other.position).append((Object)this.dateTimePattern, (Object)other.dateTimePattern).isEquals();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.decimals, this.symbol, this.position, this.dateTimePattern});
    }

    public static enum SymbolPosition {
        start,
        end;

    }
}

