/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.source;

import com.ibm.bi.predict.dataaccess.types.AggregationType;
import com.ibm.bi.predict.dataaccess.types.FieldType;
import com.ibm.bi.predict.exceptions.BadParametersException;
import com.ibm.bi.predict.source.Category;
import com.ibm.bi.predict.source.ColumnFormat;
import com.ibm.bi.predict.source.ColumnIdentifier;
import com.ibm.bi.predict.source.MetaDataAware;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.builder.EqualsBuilder;

public class ColumnMetaData
implements MetaDataAware {
    private final ColumnIdentifier identifier;
    private final int rowCount;
    private final Map<String, Double> concepts;
    private final FieldType type;
    private final AggregationType aggregation;
    private final List<Category> categories;
    private final ColumnFormat format;
    private Map<String, Object> metadata;

    public ColumnMetaData(ColumnIdentifier identifier, int rowCount, FieldType type, AggregationType aggregation, List<Category> categories, ColumnFormat format, Map<String, Double> concepts) {
        if (rowCount < 0) {
            throw new BadParametersException("Row count cannot be negative");
        }
        this.rowCount = rowCount;
        this.aggregation = aggregation;
        this.categories = categories;
        this.identifier = Objects.requireNonNull(identifier, "Identifier must be defined");
        this.concepts = Objects.requireNonNull(concepts, "Concepts may be empty, but must not be null");
        this.type = Objects.requireNonNull(type, "Type must be defined");
        this.format = Objects.requireNonNull(format, "Format must be defined");
        this.metadata = Collections.emptyMap();
        this.validateCategories();
        this.validateAggregationMatchesType();
    }

    public AggregationType aggregation() {
        return this.aggregation;
    }

    public List<Category> categories() {
        return this.categories;
    }

    public int categoryCount() {
        return this.categories == null ? 0 : this.categories.size();
    }

    public Map<String, Double> concepts() {
        return this.concepts;
    }

    public ColumnFormat format() {
        return this.format;
    }

    public ColumnIdentifier identifier() {
        return this.identifier;
    }

    public int rowCount() {
        return this.rowCount;
    }

    public FieldType type() {
        return this.type;
    }

    private void validateAggregationMatchesType() {
        Objects.requireNonNull(this.aggregation, "Aggregation must be defined");
        if (this.type == FieldType.CATEGORICAL && this.aggregation != AggregationType.NONE && this.aggregation != AggregationType.UNKNOWN) {
            throw new BadParametersException("Aggregation " + this.aggregation + " cannot result in a categorical field");
        }
    }

    private void validateCategories() {
        if (this.type == FieldType.CATEGORICAL && this.categories == null) {
            throw new BadParametersException("For categorical field types, a list of categories must be provided");
        }
        if (this.type == FieldType.NUMERICAL && this.categories != null) {
            throw new BadParametersException("For numeric field types, categories must be null");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ColumnMetaData)) {
            return false;
        }
        ColumnMetaData other = (ColumnMetaData)obj;
        return new EqualsBuilder().append((Object)this.identifier, (Object)other.identifier).append(this.rowCount, other.rowCount).append(this.concepts, other.concepts).append((Object)this.type, (Object)other.type).append((Object)this.aggregation, (Object)other.aggregation).append(this.categories, other.categories).append((Object)this.format, (Object)other.format).isEquals();
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.rowCount, this.concepts, this.type, this.aggregation, this.categories, this.format);
    }

    @Override
    public MetaDataAware putMetaData(String key, Object value) {
        if (this.metadata.isEmpty()) {
            this.metadata = new HashMap<String, Object>();
        }
        if (value == null) {
            this.metadata.remove(key);
        } else {
            this.metadata.put(key, value);
        }
        return this;
    }

    @Override
    public boolean containsMetaData(String key) {
        return this.metadata.containsKey(key);
    }

    @Override
    public Object getMetaData(String key) {
        return this.metadata.get(key);
    }
}

