/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.source;

import com.google.common.collect.Sets;
import com.ibm.bi.predict.data.DataColumn;
import com.ibm.bi.predict.source.Category;
import com.ibm.bi.predict.source.ColumnGroup;
import com.ibm.bi.predict.source.ColumnMetaData;
import com.ibm.bi.predict.source.DataColumnInfo;
import com.ibm.bi.predict.source.DataSource;
import com.ibm.bi.predict.source.LabeledIdentifier;
import com.ibm.bi.predict.source.Row;
import com.ibm.bi.predict.source.SourceMetaData;
import com.ibm.bi.predict.source.TwoDimensionalList;
import com.ibm.bi.predict.source.jsonstat.ColumnGroupType;
import com.ibm.bi.predict.types.RoleType;
import com.ibm.bi.predict.utils.Tuple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class DataColumnBuilder {
    static final Set<Enum> TIME_GROUP_TYPES = Sets.newHashSet((Object[])new Enum[]{ColumnGroupType.TIME, RoleType.EXPLANATORY});
    private final DataSource dataSource;

    private DataColumnBuilder(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public static List<DataColumn> build(DataSource dataSource) {
        return new DataColumnBuilder(dataSource).build();
    }

    private List<DataColumn> build() {
        List<DataColumnInfo> columnInfo = this.initColumnInfo();
        DataColumnInfo parentColumnInfo = new DataColumnInfo(this.dataSource.meta().rowCount(), this.makeParentCategories());
        this.populateColumnData(columnInfo, parentColumnInfo);
        return this.makeDataColumns(columnInfo, parentColumnInfo);
    }

    private List<DataColumn> makeDataColumns(List<DataColumnInfo> columnInfo, DataColumnInfo parentColumnInfo) {
        ArrayList<DataColumn> dataColumns = new ArrayList<DataColumn>();
        for (int i = 0; i < columnInfo.size(); ++i) {
            dataColumns.add(columnInfo.get(i).build(this.makeColumnMeta(i), i));
        }
        return this.setTimeColumnsParent(dataColumns, parentColumnInfo);
    }

    private List<DataColumn> setTimeColumnsParent(List<DataColumn> dataColumns, DataColumnInfo parentColumnInfo) {
        int[] timeIndices = ColumnGroup.columnsIndices(this.dataSource.groups(), TIME_GROUP_TYPES);
        if (timeIndices.length <= 1) {
            return dataColumns;
        }
        DataColumn parentColumn = parentColumnInfo.build(dataColumns, timeIndices);
        for (int i = 0; i < timeIndices.length; ++i) {
            dataColumns.get(timeIndices[i]).setParent(parentColumn);
        }
        return dataColumns;
    }

    private void populateColumnData(List<DataColumnInfo> columnInfo, DataColumnInfo parentColumnInfo) {
        Iterator<Row> rowIter = this.dataSource.rowIterator();
        int[] timeIndices = ColumnGroup.columnsIndices(this.dataSource.groups(), TIME_GROUP_TYPES);
        int[] timeCatSizes = this.timeCategorySizes(timeIndices);
        int rowIndex = 0;
        while (rowIter.hasNext()) {
            Row row = rowIter.next();
            this.addRowFieldsToColumns(row, columnInfo, rowIndex);
            if (timeIndices.length > 1) {
                int catIndex = DataColumnBuilder.makeParentCategoryIndex(row, timeIndices, timeCatSizes);
                parentColumnInfo.add(catIndex, rowIndex);
            }
            ++rowIndex;
        }
    }

    private static int makeParentCategoryIndex(Row row, int[] timeIndices, int[] timeCatSizes) {
        int index = 0;
        for (int i = 0; i < timeIndices.length; ++i) {
            index = index * timeCatSizes[i] + (int)row.valueAt(timeIndices[i]);
        }
        return index;
    }

    private int[] timeCategorySizes(int[] timeIndices) {
        List<ColumnMetaData> colMeta = this.dataSource.meta().columnMetaData();
        return Arrays.stream(timeIndices).mapToObj(colMeta::get).mapToInt(ColumnMetaData::categoryCount).toArray();
    }

    private void addRowFieldsToColumns(Row row, List<DataColumnInfo> columnInfo, int rowIndex) {
        SourceMetaData metaData = this.dataSource.meta();
        for (int colIndex = 0; colIndex < metaData.columnCount(); ++colIndex) {
            columnInfo.get(colIndex).add(row.valueAt(colIndex), rowIndex);
        }
    }

    private List<DataColumnInfo> initColumnInfo() {
        SourceMetaData metaData = this.dataSource.meta();
        ArrayList<DataColumnInfo> columnInfo = new ArrayList<DataColumnInfo>();
        for (int i = 0; i < metaData.columnCount(); ++i) {
            columnInfo.add(new DataColumnInfo(metaData.rowCount(), metaData.columnMetaData().get(i).categories()));
        }
        return columnInfo;
    }

    private List<Category> makeParentCategories() {
        int[] timeIndices = ColumnGroup.columnsIndices(this.dataSource.groups(), TIME_GROUP_TYPES);
        if (timeIndices.length <= 1) {
            return Collections.emptyList();
        }
        List categories = Arrays.stream(timeIndices).mapToObj(this.dataSource.meta().columnMetaData()::get).map(ColumnMetaData::categories).map(l -> l.stream().map(LabeledIdentifier::label).collect(Collectors.toList())).collect(Collectors.toList());
        return new TwoDimensionalList(categories).crossjoin((l, i) -> this.combineCategories((List<String>)l));
    }

    private Category combineCategories(List<String> categories) {
        String category = String.join((CharSequence)"|", categories);
        return new Category(category, category);
    }

    private DataColumn.ColumnMeta makeColumnMeta(int col) {
        List<ColumnMetaData> columnMetaData = this.dataSource.meta().columnMetaData();
        ColumnMetaData metaData = columnMetaData.get(col);
        return new DataColumn.ColumnMeta(metaData.identifier().id().toString(), metaData.identifier().label(), metaData.type(), metaData.aggregation(), DataColumnBuilder.toTupleList(columnMetaData.get(col).concepts()));
    }

    private static List<Tuple<String, Double>> toTupleList(Map<String, Double> map) {
        return map.entrySet().stream().map(e -> Tuple.of(e.getKey(), e.getValue())).collect(Collectors.toList());
    }
}

