/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.source;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;

public class TwoDimensionalList<T, R> {
    private List<List<T>> lists;

    public TwoDimensionalList(List<List<T>> lists) {
        this.lists = lists;
    }

    public List<R> crossjoin(BiFunction<List<T>, int[], R> combiner) {
        ArrayList<R> crossJoin = new ArrayList<R>();
        int[] indices = this.indices();
        ArrayList nextItems = new ArrayList(this.lists.size());
        while (this.hasNext(indices, indices.length - 1)) {
            this.next(indices, nextItems);
            crossJoin.add(combiner.apply(nextItems, indices));
        }
        return crossJoin;
    }

    private void next(int[] indices, List<T> nextItems) {
        nextItems.clear();
        for (int i = 0; i < indices.length; ++i) {
            nextItems.add(this.lists.get(i).get(indices[i]));
        }
    }

    private boolean hasNext(int[] indices, int i) {
        int n = i;
        indices[n] = indices[n] + 1;
        if (i == 0) {
            return indices[i] < this.lists.get(i).size();
        }
        int n2 = i;
        indices[n2] = indices[n2] % this.lists.get(i).size();
        if (indices[i] == 0) {
            return this.hasNext(indices, i - 1);
        }
        return true;
    }

    private int[] indices() {
        int[] indices = new int[this.lists.size()];
        Arrays.fill(indices, -1);
        return indices;
    }
}

