/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.source.builder;

import com.ibm.bi.predict.source.ColumnIdentifier;
import com.ibm.bi.predict.source.ColumnMetaData;
import com.ibm.bi.predict.source.DataSource;
import com.ibm.bi.predict.source.Row;
import com.ibm.bi.predict.source.SourceMetaData;
import com.ibm.bi.predict.source.builder.JsonStatToDataSource;
import com.ibm.bi.predict.source.builder.csv.CSVtoSourceComponents;
import com.ibm.bi.predict.source.builder.csv.DeducedDateFormat;
import com.ibm.bi.predict.source.builder.csv.SourceComponentsToDataSource;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.json.JSONObject;

public class DataSourceFactory {
    private static final int DEFAULT_ROWS_FOR_AUTO_ANALYSIS = 3333;
    private static final double DEFAULT_FRACTION_NEEDED_FOR_AUTO_NUMERIC = 0.5;

    public static DataSourceFactory instance() {
        return new DataSourceFactory();
    }

    public DataSource fromCSV(Path path) {
        return this.fromCSV(path, CSVtoSourceComponents.HeaderHandling.autoDetect, 3333, 0.5);
    }

    public DataSource fromCSV(Path path, CSVtoSourceComponents.HeaderHandling hasHeaders, int rowsToUseForAnalysis, double fractionNeededForNumeric) {
        Collection<Row> rows;
        SourceMetaData meta;
        CSVtoSourceComponents converter;
        try {
            converter = new CSVtoSourceComponents(rowsToUseForAnalysis, fractionNeededForNumeric).usePath(path, hasHeaders).process();
        }
        catch (Exception e) {
            throw new RuntimeException("Error extracting information from CSV file: " + path, e);
        }
        try {
            SourceComponentsToDataSource builder = new SourceComponentsToDataSource(converter.rows());
            ColumnIdentifier[] columnIdentifiers = converter.columnNames();
            DeducedDateFormat[] dateFormats = converter.dateFormats();
            Integer[] numericFormats = converter.decimalPlacesForNumericColumn();
            meta = builder.makeMetaData(columnIdentifiers, dateFormats, numericFormats);
            List<ColumnMetaData> columns = meta.columnMetaData();
            rows = builder.makeRows(columns);
        }
        catch (Exception e) {
            throw new RuntimeException("Error asembling info for CSV file: " + path, e);
        }
        return new DataSource(meta, rows);
    }

    public DataSource fromJSON(JSONObject json) {
        Objects.requireNonNull(json, "Invalid input JSON data");
        if (this.isJsonStat(json)) {
            return new JsonStatToDataSource(json).parse();
        }
        throw new IllegalArgumentException("Data passed in was not in a suitable format");
    }

    private boolean isJsonStat(JSONObject json) {
        return json.containsKey((Object)"id") && json.containsKey((Object)"size");
    }
}

