/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.source.builder.csv;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.stream.IntStream;

public class AutoCharset {
    public static final int MAX_CHARS_TO_READ = 40000;
    public static final char UNICODE_ERROR_CHARACTER = '\ufffd';

    private AutoCharset() {
    }

    public static Charset guess(Path path) throws IOException {
        int utf8Unknowns = AutoCharset.countUnknowns(path, StandardCharsets.UTF_8);
        if (utf8Unknowns == 0) {
            return StandardCharsets.UTF_8;
        }
        int iso8859unknowns = AutoCharset.countUnknowns(path, StandardCharsets.ISO_8859_1);
        return iso8859unknowns >= utf8Unknowns ? StandardCharsets.UTF_8 : StandardCharsets.ISO_8859_1;
    }

    private static int countUnknowns(Path path, Charset cs) throws IOException {
        try (InputStreamReader rdr = new InputStreamReader((InputStream)new FileInputStream(path.toFile()), cs);){
            char[] cbuf = new char[40000];
            int read = rdr.read(cbuf);
            int n = (int)IntStream.range(0, read).mapToObj(i -> Character.valueOf(cbuf[i])).filter(c -> c.charValue() == '\ufffd').count();
            return n;
        }
    }
}

