/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.source.builder.csv;

import com.ibm.bi.predict.math.NumericUtils;
import com.ibm.bi.predict.source.builder.csv.CSVtoSourceComponents;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.csv.CSVRecord;

public class AutoHeaders {
    private static final double FRACTION_GOOD_TO_USE_AS_HEADERS = 0.75;

    public static CSVtoSourceComponents.HeaderHandling firstCSVRowIsLikelyHeaders(List<CSVRecord> records) {
        if (records.isEmpty()) {
            return CSVtoSourceComponents.HeaderHandling.noHeaders;
        }
        CSVRecord record = records.get(0);
        int nHeaders = record.size();
        double goodHeaderScore = 0.0;
        for (int i = 0; i < record.size(); ++i) {
            int columnIndex = i;
            Stream<String> items = records.stream().skip(1L).filter(r -> r.size() == nHeaders).map(row -> row.get(columnIndex));
            goodHeaderScore += AutoHeaders.isGoodHeader(record.get(i), items);
        }
        return goodHeaderScore > 0.75 * (double)record.size() ? CSVtoSourceComponents.HeaderHandling.firstRow : CSVtoSourceComponents.HeaderHandling.noHeaders;
    }

    private static double isGoodHeader(String candidate, Stream<String> items) {
        if (candidate == null || candidate.isEmpty()) {
            return 0.55;
        }
        if (NumericUtils.tryParseDouble((String)candidate)) {
            return 0.0;
        }
        return items.anyMatch(candidate::equals) ? 0.45 : 1.0;
    }
}

