/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.source.builder.endorresultset;

import com.ibm.bi.predict.dataaccess.types.AggregationType;
import com.ibm.bi.predict.source.Category;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class EndorItems {
    private final List<Category> categories;
    private final int[] mappingArray;

    private EndorItems(List<Category> categories, int[] mappingArray) {
        this.categories = categories;
        this.mappingArray = mappingArray;
    }

    public List<Category> categories() {
        return this.categories;
    }

    public int[] mappingArray() {
        return this.mappingArray;
    }

    public static EndorItems empty() {
        return new EndorItems(Collections.emptyList(), new int[0]);
    }

    public static List<EndorItems> parse(JSONArray items) throws JSONException {
        int i;
        ArrayList<EndorItems> result = new ArrayList<EndorItems>();
        if (items == null || items.isEmpty()) {
            return result;
        }
        int nItems = items.size();
        int numFields = items.getJSONObject(0).getJSONArray("t").size();
        for (i = 1; i < nItems; ++i) {
            if (items.getJSONObject(i).getJSONArray("t").size() == numFields) continue;
            throw new JSONException("Expected all entries in the 'items' array to have the same number of fields");
        }
        for (i = 0; i < numFields; ++i) {
            result.add(EndorItems.parseField(items, nItems, i));
        }
        return result;
    }

    private static EndorItems parseField(JSONArray items, int nItems, int fieldIndex) throws JSONException {
        HashMap<String, Integer> uniqueIds = new HashMap<String, Integer>();
        ArrayList<Category> categories = new ArrayList<Category>();
        int[] mappingArray = new int[nItems];
        for (int i = 0; i < nItems; ++i) {
            JSONObject o = items.getJSONObject(i).getJSONArray("t").getJSONObject(fieldIndex);
            String d = null;
            if (o.containsKey((Object)"d")) {
                d = o.optString("d");
            } else if (o.containsKey((Object)"u")) {
                d = o.optString("u");
            }
            if (d == null) {
                d = "PREDICTNOVALUECAT_4847aaa3-2eac-4489-b1d8-1ebc8146f1aa_PREDICTNOVALUECAT";
            }
            String u = o.optString("u", d);
            String agg = o.optString("aggregate", null);
            if (uniqueIds.containsKey(u)) {
                mappingArray[i] = (Integer)uniqueIds.get(u);
                continue;
            }
            Category c = new Category(u, d);
            if (agg != null) {
                c.putMetaData("aggregate", AggregationType.fromString((String)agg));
            }
            int index = categories.size();
            categories.add(c);
            mappingArray[i] = index;
            uniqueIds.put(u, index);
        }
        return new EndorItems(categories, mappingArray);
    }
}

