/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.source.builder.endorresultset;

import com.ibm.bi.predict.dataaccess.types.FieldType;
import com.ibm.bi.predict.source.Category;
import com.ibm.bi.predict.source.ColumnFormat;
import com.ibm.bi.predict.source.ColumnGroup;
import com.ibm.bi.predict.source.ColumnIdentifier;
import com.ibm.bi.predict.source.ColumnMetaData;
import com.ibm.bi.predict.source.builder.endorresultset.EndorDataItem;
import com.ibm.bi.predict.source.builder.endorresultset.EndorItemClass;
import com.ibm.bi.predict.types.RoleType;
import com.ibm.bi.predict.utils.Tuple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;

public class EndorMetadata {
    private final List<List<EndorDataItem>> endorItems;
    private final List<ColumnGroup> columnGroups;
    private final List<ColumnMetaData> columnMetaData;

    private EndorMetadata(List<List<EndorDataItem>> endorItems, List<ColumnGroup> columnGroups, List<ColumnMetaData> columnMetaData) {
        this.endorItems = endorItems;
        this.columnGroups = columnGroups;
        this.columnMetaData = columnMetaData;
    }

    public List<List<EndorDataItem>> endorItems() {
        return this.endorItems;
    }

    public List<ColumnGroup> columnGroups() {
        return this.columnGroups;
    }

    public List<ColumnMetaData> columnMetaData() {
        return this.columnMetaData;
    }

    public static EndorMetadata parse(JSONArray dataItems, Map<String, RoleType> rolesById, Map<String, List<Tuple<String, Double>>> conceptsByUid, int rowCount) throws JSONException {
        List<List<EndorDataItem>> endorItems = EndorDataItem.parse(dataItems);
        List<List<ColumnMetaData>> columns = EndorMetadata.generateColumnMetadata(endorItems, conceptsByUid, rowCount);
        List<ColumnGroup> groups = EndorMetadata.generateColumnGroups(endorItems, columns, rolesById);
        return new EndorMetadata(endorItems, groups, columns.stream().flatMap(Collection::stream).collect(Collectors.toList()));
    }

    private static List<List<ColumnMetaData>> generateColumnMetadata(List<List<EndorDataItem>> endorItems, Map<String, List<Tuple<String, Double>>> conceptsByUid, int rowCount) {
        ArrayList<List<ColumnMetaData>> result = new ArrayList<List<ColumnMetaData>>();
        int columnIndex = 0;
        for (List<EndorDataItem> inputList : endorItems) {
            ArrayList<ColumnMetaData> resultList = new ArrayList<ColumnMetaData>();
            for (EndorDataItem item : inputList) {
                resultList.add(EndorMetadata.generateColumnMetadata(item, columnIndex, conceptsByUid, rowCount));
                ++columnIndex;
            }
            result.add(resultList);
        }
        return result;
    }

    private static ColumnMetaData generateColumnMetadata(EndorDataItem item, int columnIndex, Map<String, List<Tuple<String, Double>>> conceptsByUid, int rowCount) {
        List<Category> categories;
        FieldType fieldType;
        if (item.items().isPresent()) {
            fieldType = FieldType.CATEGORICAL;
            categories = item.items().get().categories();
        } else {
            fieldType = FieldType.NUMERICAL;
            categories = null;
        }
        EndorItemClass itemClass = item.itemClass();
        ColumnMetaData result = new ColumnMetaData(new ColumnIdentifier(itemClass.itemId(), itemClass.label(), columnIndex), rowCount, fieldType, itemClass.aggregate(), categories, ColumnFormat.formatForString(), EndorMetadata.buildConcepts(itemClass.dataId(), conceptsByUid));
        result.putMetaData("endor_data_id", itemClass.dataId());
        item.items().ifPresent(items -> result.putMetaData("category_mappings", items.mappingArray()));
        return result;
    }

    private static Map<String, Double> buildConcepts(String uid, Map<String, List<Tuple<String, Double>>> conceptsByUid) {
        List concepts = conceptsByUid.getOrDefault(uid, Collections.emptyList());
        return concepts.stream().collect(Collectors.toMap(v -> (String)v._1, v -> (Double)v._2));
    }

    private static List<ColumnGroup> generateColumnGroups(List<List<EndorDataItem>> endorItems, List<List<ColumnMetaData>> columnGroups, Map<String, RoleType> rolesById) {
        ArrayList<ColumnGroup> result = new ArrayList<ColumnGroup>();
        for (int i = 0; i < endorItems.size(); ++i) {
            List<EndorDataItem> items = endorItems.get(i);
            List<ColumnMetaData> group = columnGroups.get(i);
            String id = items.isEmpty() ? "" : items.get(0).itemClass().groupId();
            HashSet<Enum> properties = new HashSet<Enum>();
            RoleType r = rolesById.get(id);
            if (r != null) {
                properties.add((Enum)r);
            }
            result.add(new ColumnGroup(id, id, properties, group.stream().map(ColumnMetaData::identifier).collect(Collectors.toList())));
        }
        return result;
    }
}

