/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.source.builder.endorresultset;

import com.ibm.bi.predict.source.ColumnGroup;
import com.ibm.bi.predict.source.ColumnIdentifier;
import com.ibm.bi.predict.source.ColumnRelationship;
import com.ibm.bi.predict.source.builder.endorresultset.EndorMetadata;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class EndorRelationshipsBuilder {
    public static List<ColumnRelationship> buildRelationships(EndorMetadata meta) {
        ArrayList<ColumnRelationship> result = new ArrayList<ColumnRelationship>();
        Map<String, ColumnGroup> groupMap = meta.columnGroups().stream().collect(Collectors.toMap(g -> g.id().toString(), g -> g));
        List statIds = groupMap.keySet().stream().filter(EndorRelationshipsBuilder::isStatisticID).collect(Collectors.toList());
        for (String statId : statIds) {
            ColumnGroup statGroup = groupMap.get(statId);
            String[] statInfo = EndorRelationshipsBuilder.splitStatisticsID(statId);
            String relationshipName = "statistic:" + statInfo[0];
            String mainId = statInfo[1];
            ColumnGroup mainGroup = groupMap.getOrDefault(mainId, null);
            if (mainGroup == null) continue;
            for (ColumnIdentifier a : mainGroup.columns()) {
                for (ColumnIdentifier b : statGroup.columns()) {
                    result.add(new ColumnRelationship(a, relationshipName, b));
                }
            }
        }
        return result;
    }

    private static boolean isStatisticID(String id) {
        return id.contains(":");
    }

    private static String[] splitStatisticsID(String id) {
        return id.split(":");
    }
}

