/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.source.builder.endorresultset;

import com.ibm.bi.predict.source.ColumnRelationship;
import com.ibm.bi.predict.source.DataSource;
import com.ibm.bi.predict.source.Row;
import com.ibm.bi.predict.source.SourceMetaData;
import com.ibm.bi.predict.source.SourceProperty;
import com.ibm.bi.predict.source.builder.endorresultset.EndorMetadata;
import com.ibm.bi.predict.source.builder.endorresultset.EndorRelationshipsBuilder;
import com.ibm.bi.predict.source.builder.endorresultset.EndorRow;
import com.ibm.bi.predict.types.RoleType;
import com.ibm.bi.predict.utils.Tuple;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class EndorResultSetParser {
    public static final String ENDOR_DATA_ID = "endor_data_id";
    public static final String CATEGORY_MAPPINGS = "category_mappings";
    public static final String CATEGORY_AGGREGATE = "aggregate";
    public static final String STATISTIC_PREFIX = "statistic:";
    public static final String MISSING_CATEGORY_LABEL = "PREDICTNOVALUECAT_4847aaa3-2eac-4489-b1d8-1ebc8146f1aa_PREDICTNOVALUECAT";

    public static DataSource parse(JSONObject dataset, Map<String, RoleType> rolesById, Map<String, List<Tuple<String, Double>>> conceptsByUid) throws JSONException {
        JSONArray dataItems = dataset.optJSONArray("dataItems", new JSONArray());
        JSONArray dataRows = dataset.optJSONArray("data", new JSONArray());
        EndorMetadata meta = EndorMetadata.parse(dataItems, rolesById, conceptsByUid, dataRows.size());
        List<Row> rows = EndorRow.parse(dataRows, meta.endorItems());
        HashSet<SourceProperty> properties = new HashSet<SourceProperty>();
        if (dataset.optBoolean("hasNext", false)) {
            properties.add(SourceProperty.clipped);
        }
        List<ColumnRelationship> relationships = EndorRelationshipsBuilder.buildRelationships(meta);
        SourceMetaData sourceMeta = new SourceMetaData(meta.columnMetaData(), properties, relationships);
        return new DataSource(sourceMeta, rows, meta.columnGroups());
    }
}

