/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.source.builder.endorresultset;

import com.ibm.bi.predict.source.Category;
import com.ibm.bi.predict.source.Row;
import com.ibm.bi.predict.source.builder.endorresultset.EndorDataItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class EndorRow
extends Row {
    private final double[] values;
    private final Category[][] categories;

    private EndorRow(double[] values, Category[][] categories) {
        this.values = values;
        this.categories = categories;
    }

    @Override
    public double valueAt(int index) {
        return this.values[index];
    }

    @Override
    public Category categoryAt(int index) {
        return this.categories[index][(int)this.values[index]];
    }

    public static List<Row> parse(JSONArray data, List<List<EndorDataItem>> endorItems) throws JSONException {
        int[] columnsPerGroup = endorItems.stream().mapToInt(List::size).toArray();
        List flatItems = endorItems.stream().flatMap(Collection::stream).collect(Collectors.toList());
        int nColumns = flatItems.size();
        int[][] maps = new int[nColumns][];
        Category[][] cats = new Category[nColumns][];
        for (int i = 0; i < nColumns; ++i) {
            EndorDataItem item = (EndorDataItem)flatItems.get(i);
            if (item.items().isPresent()) {
                maps[i] = item.items().get().mappingArray();
                cats[i] = (Category[])item.items().get().categories().stream().toArray(Category[]::new);
                continue;
            }
            maps[i] = new int[0];
            cats[i] = new Category[0];
        }
        ArrayList<Row> result = new ArrayList<Row>();
        for (int i = 0; i < data.size(); ++i) {
            result.add(EndorRow.buildRow(data.getJSONObject(i), nColumns, columnsPerGroup, maps, cats));
        }
        return result;
    }

    private static EndorRow buildRow(JSONObject data, int nColumns, int[] columnsPerGroup, int[][] maps, Category[][] cats) throws JSONException {
        JSONArray pt = data.getJSONArray("pt");
        double[] values = new double[nColumns];
        int c = 0;
        for (int g = 0; g < columnsPerGroup.length; ++g) {
            double ptV = EndorRow.getValue(pt, g);
            int i = 0;
            while (i < columnsPerGroup[g]) {
                values[c] = maps[c].length > 0 ? (double)maps[c][(int)ptV] : ptV;
                ++i;
                ++c;
            }
        }
        return new EndorRow(values, cats);
    }

    private static double getValue(JSONArray pt, int index) throws JSONException {
        Object o = pt.get(index);
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        if (o instanceof JSONObject) {
            JSONObject obj = (JSONObject)o;
            if (!obj.containsKey((Object)"v") || !(obj.get("v") instanceof Number)) {
                return Double.NaN;
            }
            return ((JSONObject)o).getDouble("v");
        }
        throw new JSONException("Unexpected structure of 'pt' array in 'data' section, expected number or object");
    }
}

