/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.source.writer;

import com.ibm.bi.predict.dataaccess.exception.IllegalDataAccessRequest;
import com.ibm.bi.predict.dataaccess.jsonstat.JsonStat;
import com.ibm.bi.predict.source.Category;
import com.ibm.bi.predict.source.ColumnGroup;
import com.ibm.bi.predict.source.ColumnIdentifier;
import com.ibm.bi.predict.source.ColumnMetaData;
import com.ibm.bi.predict.source.DataSource;
import com.ibm.bi.predict.source.Row;
import com.ibm.bi.predict.source.jsonstat.ColumnGroupType;
import com.ibm.bi.predict.source.jsonstat.OutputFormatType;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class JsonStatWriter {
    private static final double SPARSE_THRESHOLD = 0.3;

    private JsonStatWriter() {
    }

    public static JSONObject toJsonStat(DataSource dataSource, OutputFormatType outputFormat) {
        JSONObject json = new JSONObject();
        try {
            json.put("version", (Object)"2.0");
            if (OutputFormatType.JSONSTAT_SPARSE == outputFormat || OutputFormatType.AUTO == outputFormat && JsonStatWriter.isSparse(dataSource)) {
                JsonStatWriter.putValueSparse(dataSource, json);
            } else {
                JsonStatWriter.putValueDense(dataSource, json);
            }
            JsonStatWriter.putRoleInfo(dataSource.groups(), json);
            ColumnIdentifier valueColumn = JsonStatWriter.valueColumn(dataSource);
            for (ColumnMetaData col : dataSource.meta().columnMetaData()) {
                if (col.identifier() == valueColumn) continue;
                JsonStatWriter.putDimensionInfo(col, json);
            }
            return json;
        }
        catch (JSONException e) {
            throw new IllegalDataAccessRequest("Error generating JSON for a JsonStat object", e);
        }
    }

    private static boolean isSparse(DataSource dataSource) {
        ColumnIdentifier valueColumn = JsonStatWriter.valueColumn(dataSource);
        Iterator<Row> it = dataSource.rowIterator();
        int nullCount = 0;
        int totalCount = 0;
        while (it.hasNext()) {
            Row row = it.next();
            double value = row.valueOf(valueColumn);
            if (Double.isNaN(value)) {
                ++nullCount;
            }
            ++totalCount;
        }
        return (double)nullCount > (double)totalCount * 0.3;
    }

    static void putValueDense(DataSource dataSource, JSONObject json) throws JSONException {
        ColumnIdentifier valueColumn = JsonStatWriter.valueColumn(dataSource);
        JSONArray valueArray = new JSONArray();
        Iterator<Row> it = dataSource.rowIterator();
        while (it.hasNext()) {
            Row row = it.next();
            double value = row.valueOf(valueColumn);
            if (!Double.isNaN(value)) {
                valueArray.add((Object)value);
                continue;
            }
            valueArray.add(null);
        }
        json.put("value", (Collection)valueArray);
    }

    static void putValueSparse(DataSource dataSource, JSONObject json) throws JSONException {
        ColumnIdentifier valueColumn = JsonStatWriter.valueColumn(dataSource);
        JSONObject valueObject = new JSONObject();
        Iterator<Row> it = dataSource.rowIterator();
        int ordinal = 0;
        while (it.hasNext()) {
            Row row = it.next();
            double value = row.valueOf(valueColumn);
            if (!Double.isNaN(value)) {
                valueObject.put(String.valueOf(ordinal), value);
            }
            ++ordinal;
        }
        json.put("value", (Map)valueObject);
    }

    private static ColumnIdentifier valueColumn(DataSource dataSource) {
        return dataSource.groups().stream().filter(group -> group.hasProperty(ColumnGroupType.VALUE)).findFirst().get().columns().get(0);
    }

    static void putRoleInfo(List<ColumnGroup> groups, JSONObject json) throws JSONException {
        for (ColumnGroup group : groups) {
            if (group.hasProperty(ColumnGroupType.VALUE)) continue;
            for (ColumnIdentifier col : group.columns()) {
                JsonStatWriter.role(json, group.id().toString()).add(col.id());
            }
        }
    }

    static void putDimensionInfo(ColumnMetaData column, JSONObject jsonStat) throws JSONException {
        JsonStatWriter.id(jsonStat).add(column.identifier().id());
        JsonStatWriter.size(jsonStat).add((Object)column.categoryCount());
        JSONObject category = new JSONObject();
        JSONObject index = new JSONObject();
        for (int i = 0; i < column.categoryCount(); ++i) {
            Category cat = column.categories().get(i);
            index.put(cat.id().toString(), i);
        }
        category.put(JsonStat.INDEX_KEY, (Object)index);
        JSONObject children = new JSONObject();
        for (Category cat : column.categories()) {
            if (cat.children().isEmpty()) continue;
            children.put(cat.id(), (Object)new JSONArray((Collection)cat.children().stream().map(child -> child.id()).collect(Collectors.toList())));
        }
        if (!children.isEmpty()) {
            category.put("child", (Map)children);
        }
        JSONObject dimValue = new JSONObject();
        dimValue.put("category", (Map)category);
        JSONObject dimension = JsonStatWriter.dimension(jsonStat);
        dimension.put(column.identifier().id(), (Object)dimValue);
    }

    private static JSONArray id(JSONObject jsonStat) throws JSONException {
        return JsonStatWriter.getOrCreateArray(jsonStat, "id");
    }

    private static JSONArray size(JSONObject jsonStat) throws JSONException {
        return JsonStatWriter.getOrCreateArray(jsonStat, "size");
    }

    private static JSONArray role(JSONObject jsonStat, String role) throws JSONException {
        JSONObject roleObject = JsonStatWriter.getOrCreateObject(jsonStat, "role");
        return JsonStatWriter.getOrCreateArray(roleObject, role);
    }

    private static JSONObject dimension(JSONObject jsonStat) throws JSONException {
        return JsonStatWriter.getOrCreateObject(jsonStat, "dimension");
    }

    private static JSONObject getOrCreateObject(JSONObject json, String key) throws JSONException {
        if (json.has(key)) {
            return json.getJSONObject(key);
        }
        return json.put(key, (Map)new JSONObject()).getJSONObject(key);
    }

    private static JSONArray getOrCreateArray(JSONObject json, String key) throws JSONException {
        if (json.has(key)) {
            return json.getJSONArray(key);
        }
        return json.put(key, (Collection)new JSONArray()).getJSONArray(key);
    }
}

