/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.testharness.datadriven;

import com.ibm.bi.predict.testharness.Harness;
import com.ibm.bi.predict.testharness.TaskParameters;
import com.ibm.bi.predict.testharness.User;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.io.File;
import java.nio.file.Paths;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.function.Function;

public abstract class ConcurrentTestingHarness {
    private static Logger LOGGER = PredictLoggerFactory.getLogger(ConcurrentTestingHarness.class);
    public static final String NUM_USERS = "numUsers";
    public static final String NUM_REQUESTS = "numRequests";
    public static final String OUTPUT_FOLDER = "outputFolder";
    private Harness.StatsDetail detailLevel;
    private String outputFolder = "test-runs";
    private int[] numUsers = new int[]{1};
    private int[] numRequests = new int[]{3};

    protected ConcurrentTestingHarness() {
        this.detailLevel = Harness.StatsDetail.all;
        this.getSystemProperties();
    }

    private void getSystemProperties() {
        String numUsersParam = System.getProperty(NUM_USERS);
        try {
            this.numUsers = ConcurrentTestingHarness.createIntArray(numUsersParam);
        }
        catch (Exception e) {
            LOGGER.warn(String.format("Exception attempting to convert numUser param %s to array, defaulting to %d users", numUsersParam, this.numUsers[0]));
        }
        String numRequestsParam = System.getProperty(NUM_REQUESTS);
        try {
            this.numRequests = ConcurrentTestingHarness.createIntArray(numRequestsParam);
        }
        catch (Exception e) {
            LOGGER.warn(String.format("Exception attempting to convert numRequests param %s to array, defaulting to %d users", numRequestsParam, this.numRequests[0]));
        }
        String baseFolder = this.outputFolder;
        if (System.getProperties().containsKey(OUTPUT_FOLDER)) {
            baseFolder = System.getProperty(OUTPUT_FOLDER);
        }
        Date date = new Date();
        long time = date.getTime();
        Timestamp ts = new Timestamp(time);
        this.outputFolder = String.format("%s/results_%s", baseFolder, ts.toString());
        ConcurrentTestingHarness.createOutputFolder(this.outputFolder);
        LOGGER.info(() -> String.format("Tests have been configured with Users=%s, RequestsPerUser=%s, OutputFolder=%s", Arrays.toString(this.numUsers), Arrays.toString(this.numRequests), this.outputFolder));
    }

    private static int[] createIntArray(String str) {
        return Arrays.stream(str.split(",")).map(String::trim).mapToInt(Integer::parseInt).toArray();
    }

    protected void detailLevel(Harness.StatsDetail detailLevel) {
        this.detailLevel = detailLevel;
    }

    protected static void createOutputFolder(String outputFolder) {
        File file = new File(outputFolder);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    protected void run_concurrency_test_with_harness(String testName, Function<TaskParameters, String> action, TaskParameters params) {
        Harness harness = new Harness(testName, Paths.get(this.outputFolder, new String[0])).outputDetail(this.detailLevel);
        for (int i = 0; i < this.numUsers.length; ++i) {
            int userCount = this.numUsers[i];
            for (int j = 0; j < this.numRequests.length; ++j) {
                int taskCount = this.numRequests[j];
                TaskParameters p = new TaskParameters(new String[0], new Comparable[0]);
                p.content.putAll(params.content);
                p.content.put(NUM_USERS, userCount);
                p.content.put(NUM_REQUESTS, taskCount);
                harness.addStep(User.withRepeatedTask(action, (int)taskCount, (TaskParameters)p), userCount);
            }
        }
        harness.run();
    }
}

