/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.util;

import com.ibm.bi.predict.dataaccess.DataAccessProvider;
import com.ibm.bi.predict.util.DataAccessProviderImpl;
import java.util.LinkedList;
import java.util.Random;

public class DataGenerator {
    public static final double[][] static_data = new double[][]{{1.0, 0.0, 1.0, 0.0, 1.0}, {1.0, 0.0, 2.0, 1.0, 0.0}, {1.0, 0.0, 2.0, 0.0, 2.0}, {1.0, 1.0, 3.0, 0.0, 1.0}, {1.0, 1.0, 2.0, 1.0, 0.0}, {1.0, 1.0, 3.0, 1.0, 0.0}, {1.0, 1.0, 1.0, 0.0, 0.0}, {1.0, 2.0, 1.0, 1.0, 1.0}, {1.0, 2.0, 0.0, 1.0, 0.0}, {1.0, 2.0, 1.0, 0.0, 2.0}, {1.0, 3.0, 0.0, 0.0, 2.0}, {1.0, 3.0, 0.0, 1.0, 2.0}, {1.0, 3.0, 2.0, 1.0, 0.0}, {1.0, 3.0, 1.0, 1.0, 2.0}, {1.0, 3.0, 2.0, 1.0, 1.0}, {2.0, 0.0, 1.0, 1.0, 1.0}, {2.0, 0.0, 1.0, 0.0, 1.0}, {2.0, 0.0, 3.0, 0.0, 2.0}, {2.0, 0.0, 2.0, 1.0, 1.0}, {2.0, 0.0, 3.0, 0.0, 0.0}, {2.0, 1.0, 2.0, 0.0, 0.0}, {2.0, 1.0, 2.0, 1.0, 0.0}, {2.0, 1.0, 0.0, 1.0, 1.0}, {2.0, 1.0, 3.0, 0.0, 0.0}, {2.0, 1.0, 0.0, 1.0, 2.0}, {2.0, 2.0, 3.0, 1.0, 2.0}, {2.0, 2.0, 3.0, 0.0, 2.0}, {2.0, 2.0, 1.0, 0.0, 0.0}, {2.0, 2.0, 0.0, 1.0, 2.0}, {2.0, 2.0, 1.0, 0.0, 1.0}, {2.0, 3.0, 0.0, 0.0, 1.0}, {2.0, 3.0, 0.0, 1.0, 1.0}, {2.0, 3.0, 2.0, 0.0, 2.0}, {2.0, 3.0, 1.0, 1.0, 1.0}, {3.0, 0.0, 2.0, 1.0, 0.0}, {3.0, 0.0, 1.0, 1.0, 0.0}, {3.0, 0.0, 1.0, 0.0, 0.0}, {3.0, 0.0, 3.0, 0.0, 1.0}, {3.0, 0.0, 2.0, 0.0, 0.0}, {3.0, 1.0, 3.0, 1.0, 2.0}, {3.0, 1.0, 2.0, 0.0, 2.0}, {3.0, 1.0, 2.0, 1.0, 2.0}, {3.0, 2.0, 0.0, 1.0, 0.0}, {3.0, 2.0, 3.0, 0.0, 2.0}, {3.0, 2.0, 0.0, 0.0, 1.0}, {3.0, 3.0, 3.0, 1.0, 1.0}, {3.0, 3.0, 3.0, 0.0, 1.0}, {3.0, 3.0, 1.0, 0.0, 2.0}, {3.0, 3.0, 0.0, 1.0, 1.0}};

    private DataGenerator() {
    }

    public static double[][] generateData(int nrow, int ncol) {
        double[][] result = new double[nrow][ncol];
        Random r = new Random(1L);
        for (int i = 0; i < nrow; ++i) {
            double[] row = new double[ncol];
            row[0] = r.nextDouble();
            for (int j = 1; j < ncol; ++j) {
                row[j] = r.nextInt(5);
            }
            result[i] = row;
        }
        for (int col = 1; col < ncol; ++col) {
            for (int row = 0; row < 5; ++row) {
                result[r.nextInt((int)nrow)][col] = row;
            }
        }
        return result;
    }

    public static DataAccessProvider getDataAccessProvider(double[][] data) {
        return DataGenerator.getDataAccessProvider(data, new int[]{0});
    }

    public static DataAccessProvider getDataAccessProvider(double[][] data, int[] numericFields) {
        LinkedList<String> testFields = new LinkedList<String>();
        if (data.length > 0) {
            for (int i = 0; i < data[0].length; ++i) {
                testFields.add(Integer.toString(i));
            }
        }
        return new DataAccessProviderImpl(data, testFields, numericFields);
    }

    public static DataAccessProvider getDataAccessProvider(double[][] data, int[] numericFields, boolean hasRowCount, boolean hasSumOfSquares, int targetIndex) {
        LinkedList<String> testFields = new LinkedList<String>();
        int rowCountIndex = -1;
        int sumOfSquaresIndex = -1;
        if (hasRowCount) {
            rowCountIndex = data[0].length - 1;
            if (hasSumOfSquares) {
                sumOfSquaresIndex = rowCountIndex--;
            }
        }
        if (data.length > 0) {
            for (int i = 0; i < data[0].length; ++i) {
                if (i == rowCountIndex) {
                    testFields.add("rowCount:" + Integer.toString(targetIndex));
                    continue;
                }
                if (i == sumOfSquaresIndex) {
                    testFields.add("sumSqr:" + Integer.toString(targetIndex));
                    continue;
                }
                testFields.add(Integer.toString(i));
            }
        }
        return new DataAccessProviderImpl(data, testFields, numericFields);
    }
}

