/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.util;

import com.ibm.bi.predict.dataaccess.MetaData;
import com.ibm.bi.predict.dataaccess.exception.IllegalDataAccessRequest;
import com.ibm.bi.predict.dataaccess.types.AggregationType;
import com.ibm.bi.predict.dataaccess.types.FieldType;
import com.ibm.bi.predict.dataaccess.types.StatisticStatus;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class MetaDataImpl
implements MetaData {
    private final double[][] data;
    private final List<String> fields;
    private final List<AggregationType> aggTypes;
    private final Set<Integer> numericFields;

    public MetaDataImpl(double[][] data, List<String> fields, List<AggregationType> aggTypes, int[] numericFields) {
        this.data = data;
        this.fields = fields;
        this.aggTypes = aggTypes;
        this.numericFields = IntStream.of(numericFields).boxed().collect(Collectors.toSet());
    }

    @Override
    public int fieldCount() {
        return this.fields.size();
    }

    @Override
    public int getFieldCategories(int idx) throws IllegalDataAccessRequest {
        HashSet<Double> categories = new HashSet<Double>();
        for (int i = 0; i < this.data.length; ++i) {
            categories.add(this.data[i][idx]);
        }
        return categories.size();
    }

    @Override
    public String getFieldIdentifier(int idx) throws IllegalDataAccessRequest {
        return this.fields.get(idx);
    }

    @Override
    public FieldType getFieldType(int idx) {
        return this.numericFields.contains(idx) ? FieldType.NUMERICAL : FieldType.CATEGORICAL;
    }

    @Override
    public StatisticStatus getStatisticStatus(String arg0, int arg1) throws IllegalDataAccessRequest {
        return StatisticStatus.UNAVAILABLE;
    }

    @Override
    public int rowCount() {
        return this.data.length;
    }

    @Override
    public String getFieldDisplayLabel(int arg0) {
        return "LABEL_" + arg0;
    }

    @Override
    public List<AggregationType> getFieldCategoryAggregations(int columnIndex, int categoryIndex) {
        return Collections.emptyList();
    }

    @Override
    public String getFieldCategoryLabel(int columnIndex, int categoryIndex) {
        return "category_" + String.valueOf(categoryIndex);
    }

    @Override
    public AggregationType getFieldAggregation(int columnIndex) {
        return this.aggTypes.get(columnIndex);
    }
}

