/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.frf;

import com.google.common.collect.Sets;
import com.ibm.bi.predict.explore.ExploreService;
import com.ibm.bi.predict.explore.frf.async.AsyncList;
import com.ibm.bi.predict.explore.frf.async.AsyncServiceExecutor;
import com.ibm.bi.predict.explore.frf.async.MoserJoinGraphAsyncService;
import com.ibm.bi.predict.explore.frf.async.SmartsAsyncService;
import com.ibm.bi.predict.explore.frf.async.SmartsResponse;
import com.ibm.bi.predict.explore.frf.async.TablesResponse;
import com.ibm.bi.predict.explore.frf.datamodel.DatabaseProvider;
import com.ibm.bi.predict.explore.frf.datamodel.FieldCharacteristics;
import com.ibm.bi.predict.explore.frf.datamodel.IdentifierUtilities;
import com.ibm.bi.predict.explore.frf.datamodel.TableCharacteristics;
import com.ibm.bi.predict.explore.frf.datamodel.TableConnectionFilter;
import com.ibm.bi.predict.explore.frf.framework.FRFContext;
import com.ibm.bi.predict.explore.frf.framework.RelevantFields;
import com.ibm.bi.predict.explore.frf.framework.RelevantFieldsFailureResult;
import com.ibm.bi.predict.explore.frf.framework.RelevantFieldsResult;
import com.ibm.bi.predict.explore.frf.framework.RelevantFieldsSuccessResult;
import com.ibm.bi.predict.explore.frf.performance.ListBuilder;
import com.ibm.bi.predict.explore.frf.performance.PerformanceModel;
import com.ibm.bi.predict.explore.frf.smarts.FieldSmartsRelevance;
import com.ibm.bi.predict.result.Message;
import com.ibm.bi.predict.result.MessageCode;
import com.ibm.bi.predict.service.PredictServiceFramework;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class FastRelevantFieldService
implements PredictServiceFramework {
    private static final Logger LOGGER = PredictLoggerFactory.getLogger(ExploreService.class);
    private static final String CATASTROPHIC_ERROR_MESSAGE = "Unexpected internal error in FastRelevantFieldService";
    private static final int NUM_THREADS = 3;

    FastRelevantFieldService() {
    }

    public static FastRelevantFieldService getService() {
        return new FastRelevantFieldService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RelevantFieldsResult evaluate(FRFContext context) {
        long startTime = System.currentTimeMillis();
        LOGGER.debug("Starting evaluate, moduleId={}, maxRelevantFields={}, targets={}", new Object[]{context.getString("frf.params.moduleId", null), context.getInt("frf.params.maxRelevantFields", 0), Objects.toString(context.getStringList("frf.params.targets", null))});
        AsyncList<String> allMessages = new AsyncList<String>();
        AsyncServiceExecutor executor = new AsyncServiceExecutor(3, allMessages::accept);
        try {
            List targetFieldIds = context.getStringList("frf.params.targets", new ArrayList());
            LOGGER.debug(() -> "FRF: Begin submit request, targets = " + Objects.toString(targetFieldIds));
            Supplier<TablesResponse> tablesRequest = this.submitTablesRequest(context, executor);
            Supplier<SmartsResponse> smartsRequest = this.submitSmartsRequest(context, executor);
            TablesResponse tablesResponse = tablesRequest.get();
            SmartsResponse smartsResponse = smartsRequest.get();
            LOGGER.debug("Finished getting Tables and Smarts at {} ms", (Object)FastRelevantFieldService.elapsedTime(startTime));
            if (!smartsResponse.isUsable()) {
                RelevantFieldsResult relevantFieldsResult = this.getFailedRelevantFieldsResult(context, smartsResponse, startTime, allMessages);
                return relevantFieldsResult;
            }
            if (!tablesResponse.isUsable()) {
                tablesResponse = this.makeTablesResponseFromSmarts(smartsResponse, targetFieldIds);
            }
            tablesResponse = new TablesResponse(true, TableConnectionFilter.filter((List)tablesResponse.get(), targetFieldIds));
            RelevantFieldsResult relevantFieldsResult = this.determineRelevantFields(context, smartsResponse, tablesResponse, startTime, allMessages);
            return relevantFieldsResult;
        }
        catch (Exception e) {
            LOGGER.error(CATASTROPHIC_ERROR_MESSAGE, (Throwable)e);
            allMessages.add(CATASTROPHIC_ERROR_MESSAGE);
            RelevantFieldsResult relevantFieldsResult = FastRelevantFieldService.getErrorRelevantFieldsResult(context, allMessages);
            return relevantFieldsResult;
        }
        finally {
            executor.shutdownNow();
        }
    }

    Supplier<TablesResponse> submitTablesRequest(FRFContext context, AsyncServiceExecutor executor) {
        return executor.submit(new MoserJoinGraphAsyncService(context));
    }

    Supplier<SmartsResponse> submitSmartsRequest(FRFContext context, AsyncServiceExecutor executor) {
        return executor.submit(new SmartsAsyncService(context));
    }

    private RelevantFieldsResult determineRelevantFields(FRFContext context, SmartsResponse smartsResponse, TablesResponse tablesResponse, long startTime, List<String> diagnosticMessages) {
        PerformanceModel perfModel = this.getPerformanceModel(context, tablesResponse, startTime);
        RelevantFields relevantFields = this.buildRelevantFields(context, tablesResponse, smartsResponse, perfModel, diagnosticMessages);
        LOGGER.debug("Time to build relevant fields {} ms", (Object)FastRelevantFieldService.elapsedTime(startTime));
        RelevantFieldsSuccessResult rfr = new RelevantFieldsSuccessResult(relevantFields, context.getBoolean("frf.params.getAllJoinableFields", false), context.getBoolean("frf.params.getAlternateFields", false));
        if (tablesResponse.isUsable()) {
            List<FieldCharacteristics> targetFields = tablesResponse.getFieldCharacteristicsForTargets(context.getStringList("frf.params.targets", new ArrayList()));
            if (targetFields.size() < context.getStringList("frf.params.targets", new ArrayList()).size()) {
                diagnosticMessages.add(AsyncServiceExecutor.formatDiagnostics("Unmatched targets. params.targets={}", context.getStringList("frf.params.targets", new ArrayList()).toString()));
            }
            if (context.isFMPackage()) {
                rfr.addWarningMessage(new Message(MessageCode.FRF_22_LIMIT_TO_QUERY_SUBJECT, context.getLocale("locale")));
            }
        }
        if (relevantFields.recommendedFields().isEmpty()) {
            rfr.addWarningMessage(new Message(MessageCode.FRF_42_NO_DRIVERS, context.getLocale("locale")));
        }
        diagnosticMessages.add(this.recordFieldCounts(relevantFields, smartsResponse.fieldsRelevanceAsMap().size()));
        rfr.addDiagnosticMessages(diagnosticMessages);
        LOGGER.debug("Returning success, elapsed time {} ms", (Object)FastRelevantFieldService.elapsedTime(startTime));
        return rfr;
    }

    private PerformanceModel getPerformanceModel(FRFContext context, TablesResponse tablesResponse, long startTime) {
        if (tablesResponse.isUsable()) {
            PerformanceModel perfModel = PerformanceModel.makeFor(context.identifierPrefix(), tablesResponse.tableCharacteristicsAsMap(), context.getDouble("frf.config.minimumModelConfidence", 0.6));
            LOGGER.debug("Got performance model, elapsed time {} ms", (Object)FastRelevantFieldService.elapsedTime(startTime));
            return perfModel;
        }
        LOGGER.debug("No table results, using default model, elapsed time {} ms", (Object)FastRelevantFieldService.elapsedTime(startTime));
        return PerformanceModel.defaultModel();
    }

    private RelevantFields buildRelevantFields(FRFContext context, TablesResponse tableResponse, SmartsResponse smartsResponse, PerformanceModel perfModel, List<String> diagnosticMessages) {
        List targetsList = context.getStringList("frf.params.targets", new ArrayList());
        String[] targetsArray = new String[targetsList.size()];
        for (int i = 0; i < targetsList.size(); ++i) {
            targetsArray[i] = (String)targetsList.get(i);
        }
        ListBuilder builder = new ListBuilder(tableResponse.tableCharacteristicsAsMap(), smartsResponse.fieldsRelevanceAsMap(), targetsArray, context.getInt("frf.params.maxRelevantFields", 0), context.identifierPrefix(), diagnosticMessages::add);
        builder.build(relevantFields -> perfModel.predict((List<FieldCharacteristics>)relevantFields), field -> this.relevanceOf(smartsResponse.fieldsRelevanceAsMap(), (FieldCharacteristics)field));
        RelevantFields result = new RelevantFields().setAllJoinableFields(builder.allFields()).setRecommendedFields(builder.recommendedFields(), builder.recommendedPerformance());
        if (builder.hasAlternateRecommendation()) {
            result.setAlternateFields(builder.alternateFields(), builder.alternatePerformance());
        }
        return result;
    }

    private TablesResponse makeTablesResponseFromSmarts(SmartsResponse smartsResponse, List<String> targets) {
        Sets.SetView allIds = Sets.union(smartsResponse.relevantFieldIds(), (Set)Sets.newHashSet(targets));
        Map tableInfo = allIds.stream().collect(Collectors.groupingBy(IdentifierUtilities::tableIdFromFieldId, Collectors.mapping(IdentifierUtilities::fieldNameFromFieldId, Collectors.toSet())));
        List<TableCharacteristics> tableCharacteristics = tableInfo.keySet().stream().map(id -> this.makeSmartsTable((String)id, (Set)tableInfo.get(id))).collect(Collectors.toList());
        return new TablesResponse(true, tableCharacteristics);
    }

    private TableCharacteristics makeSmartsTable(String id, Set<String> fields) {
        TableCharacteristics table = new TableCharacteristics(id, DatabaseProvider.UNKNOWN, null);
        fields.forEach(fid -> table.addField(new FieldCharacteristics(id + "." + fid, (String)fid, "CHAR(20)")));
        return table;
    }

    private FieldSmartsRelevance relevanceOf(Map<String, FieldSmartsRelevance> fieldSmartsRelevances, FieldCharacteristics field) {
        return fieldSmartsRelevances.computeIfAbsent(field.id(), f -> new FieldSmartsRelevance((String)f, -1.0));
    }

    private RelevantFieldsResult getFailedRelevantFieldsResult(FRFContext context, SmartsResponse smartsResponse, long startTime, List<String> diagnosticMessages) {
        RelevantFieldsSuccessResult rfr = new RelevantFieldsSuccessResult(new RelevantFields(), context.getBoolean("frf.params.getAllJoinableFields", false), context.getBoolean("frf.params.getAlternateFields", false));
        if (smartsResponse.requestFailed()) {
            String message = AsyncServiceExecutor.formatDiagnostics("Returning Smarts failure, elapsed time {} ms", FastRelevantFieldService.elapsedTime(startTime));
            diagnosticMessages.add(message);
            LOGGER.debug(message);
            rfr.addErrorMessage(new Message(MessageCode.FRF_42_NO_DRIVERS, context.getLocale("locale")));
        } else {
            LOGGER.debug("received empty smarts result.");
            rfr.addWarningMessage(new Message(MessageCode.FRF_42_NO_DRIVERS, context.getLocale("locale")));
            diagnosticMessages.add(this.recordFieldCounts(new RelevantFields(), 0));
        }
        rfr.addDiagnosticMessages(diagnosticMessages);
        return rfr;
    }

    private static RelevantFieldsResult getErrorRelevantFieldsResult(FRFContext context, List<String> diagnosticMessages) {
        RelevantFieldsFailureResult rfr = new RelevantFieldsFailureResult(RelevantFields.EMPTY);
        rfr.addErrorMessage(new Message(MessageCode.FRF_50_SERVICE_ERROR, context.getLocale("locale")));
        rfr.addDiagnosticMessages(diagnosticMessages);
        return rfr;
    }

    private String recordFieldCounts(RelevantFields result, int smartsSize) {
        int recommendedFields = result.recommendedFields().size();
        int alternateFields = result.getAlternateFields().size();
        int joinableFields = result.allJoinableFields().size();
        return AsyncServiceExecutor.formatDiagnostics("Counts - Smarts recommended fields: {}, FRF recommended fields: {}, alternates: {}, joinable fields: {}", smartsSize, recommendedFields, alternateFields, joinableFields);
    }

    private static long elapsedTime(long startTime) {
        return System.currentTimeMillis() - startTime;
    }
}

