/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.frf.async;

import com.ibm.bi.predict.explore.frf.async.AsyncService;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.slf4j.helpers.MessageFormatter;

public class AsyncServiceExecutor {
    static final String SUCCESS_MESSAGE = "{}: Received result, elapsed time {} ms";
    static final String SUBMITERROR_MESSAGE = "{}: Exception submitting request: {}";
    static final String EXECUTIONERROR_MESSAGE = "{}: Exception executing request: {}";
    static final String INTERRUPT_MESSAGE = "{}: Request was interrupted";
    static final String TIMEOUT_MESSAGE = "{}: Request timed out ({} milliseconds allowed)";
    static final String EXEC_ERROR_MESSAGE = "{}: Error during processing: {}";
    static final String UNKNOWN_MESSAGE = "{}: Unexpected error during processing: {}";
    ExecutorService executor;
    Consumer<String> diagnostics;

    public AsyncServiceExecutor(int numThreads, Consumer<String> diagnostics) {
        this.executor = Executors.newFixedThreadPool(numThreads);
        this.diagnostics = diagnostics;
    }

    public void shutdownNow() {
        this.executor.shutdownNow();
    }

    public void accept(String message) {
        this.diagnostics.accept(message);
    }

    public <T> Supplier<T> submit(AsyncService<T> service) {
        AsyncServiceRunnerJob<T> job = new AsyncServiceRunnerJob<T>(service);
        job.submit();
        return job;
    }

    public static String formatDiagnostics(String template, Object ... params) {
        return MessageFormatter.arrayFormat((String)template, (Object[])params).getMessage();
    }

    private class AsyncServiceRunnerJob<T>
    implements Supplier<T> {
        private final AsyncService<T> service;
        private final String identifier;
        private CompletableFuture<T> future;
        private T result;

        AsyncServiceRunnerJob(AsyncService<T> service) {
            this.service = service;
            this.identifier = service.name();
            this.future = null;
            this.result = null;
        }

        void submit() {
            try {
                long submitTime = System.currentTimeMillis();
                this.future = CompletableFuture.supplyAsync(() -> {
                    try {
                        T response = this.service.getResult(AsyncServiceExecutor.this.executor, AsyncServiceExecutor.this.diagnostics);
                        AsyncServiceExecutor.this.diagnostics.accept(AsyncServiceExecutor.formatDiagnostics(AsyncServiceExecutor.SUCCESS_MESSAGE, this.identifier, System.currentTimeMillis() - submitTime));
                        return response;
                    }
                    catch (Exception e) {
                        AsyncServiceExecutor.this.diagnostics.accept(AsyncServiceExecutor.formatDiagnostics(AsyncServiceExecutor.EXECUTIONERROR_MESSAGE, this.identifier, e.getMessage()));
                        return this.service.failedResult();
                    }
                }, AsyncServiceExecutor.this.executor);
            }
            catch (Exception e) {
                AsyncServiceExecutor.this.diagnostics.accept(AsyncServiceExecutor.formatDiagnostics(AsyncServiceExecutor.SUBMITERROR_MESSAGE, this.identifier, e.getMessage()));
                this.result = this.service.failedResult();
            }
        }

        @Override
        public T get() {
            if (this.result == null) {
                try {
                    this.result = this.future.get(this.service.timeoutInMillis(), TimeUnit.MILLISECONDS);
                    return this.result;
                }
                catch (InterruptedException | CancellationException e) {
                    AsyncServiceExecutor.this.diagnostics.accept(AsyncServiceExecutor.formatDiagnostics(AsyncServiceExecutor.INTERRUPT_MESSAGE, this.identifier));
                }
                catch (ExecutionException e) {
                    AsyncServiceExecutor.this.diagnostics.accept(AsyncServiceExecutor.formatDiagnostics(AsyncServiceExecutor.EXEC_ERROR_MESSAGE, this.identifier));
                }
                catch (TimeoutException e) {
                    AsyncServiceExecutor.this.diagnostics.accept(AsyncServiceExecutor.formatDiagnostics(AsyncServiceExecutor.TIMEOUT_MESSAGE, this.identifier, this.service.timeoutInMillis()));
                }
                catch (Exception e) {
                    AsyncServiceExecutor.this.diagnostics.accept(AsyncServiceExecutor.formatDiagnostics(AsyncServiceExecutor.UNKNOWN_MESSAGE, this.identifier));
                }
                this.result = this.service.failedResult();
            }
            return this.result;
        }
    }
}

