/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.frf.async;

import com.ibm.bi.predict.explore.frf.async.AsyncService;
import com.ibm.bi.predict.explore.frf.async.TablesResponse;
import com.ibm.bi.predict.explore.frf.framework.FRFContext;
import com.ibm.bi.predict.explore.frf.moser.MoserAccess;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;

public class MoserAsyncService
implements AsyncService<TablesResponse> {
    private final FRFContext context;

    public MoserAsyncService(FRFContext context) {
        this.context = context;
    }

    @Override
    public String name() {
        return "Moser";
    }

    @Override
    public int timeoutInMillis() {
        return this.context.getInt("frf.config.moserTimeoutInMillis", 20000);
    }

    @Override
    public TablesResponse getResult(ExecutorService executor, Consumer<String> diagnostics) throws Exception {
        MoserAccess moser = this.makeMoserAccess(this.context, diagnostics);
        return new TablesResponse(true, moser.build(executor));
    }

    @Override
    public TablesResponse failedResult() {
        return TablesResponse.failedResponse();
    }

    MoserAccess makeMoserAccess(FRFContext context, Consumer<String> diagnostics) {
        return new MoserAccess(context, diagnostics);
    }
}

