/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.frf.datamodel;

public enum Cardinality {
    ONE_TO_ONE,
    ONE_TO_MANY,
    MANY_TO_ONE,
    MANY_TO_MANY;


    public static Cardinality valueOf(String left, String right) {
        return Cardinality.valueOf(left.toUpperCase() + "_TO_" + right.toUpperCase());
    }

    public static Cardinality joinGraphValueOf(String card) {
        switch (card) {
            case "1:1": {
                return ONE_TO_ONE;
            }
            case "1:N": {
                return ONE_TO_MANY;
            }
            case "N:1": {
                return MANY_TO_ONE;
            }
        }
        return MANY_TO_MANY;
    }

    public static Cardinality better(Cardinality a, Cardinality b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (a == ONE_TO_ONE || b == ONE_TO_ONE) {
            return ONE_TO_ONE;
        }
        if (a == MANY_TO_ONE || b == MANY_TO_ONE) {
            return MANY_TO_ONE;
        }
        if (a == ONE_TO_MANY || b == ONE_TO_MANY) {
            return ONE_TO_MANY;
        }
        return MANY_TO_MANY;
    }

    public static Cardinality reverse(Cardinality a) {
        if (a == null || a == ONE_TO_ONE || a == MANY_TO_MANY) {
            return a;
        }
        if (a == MANY_TO_ONE) {
            return ONE_TO_MANY;
        }
        if (a == ONE_TO_MANY) {
            return MANY_TO_ONE;
        }
        throw new IllegalArgumentException("Unknown cardinality: " + (Object)((Object)a));
    }
}

