/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.frf.datamodel;

import com.ibm.bi.predict.explore.frf.datamodel.DataTypes;
import com.ibm.bi.predict.explore.frf.datamodel.TableCharacteristics;
import com.ibm.bi.predict.types.Identifiable;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class FieldCharacteristics
implements Identifiable {
    private static final Logger LOG = PredictLoggerFactory.getLogger(FieldCharacteristics.class);
    private final String id;
    private final String serializedName;
    private final List<TableCharacteristics> tableCharacteristics;
    private final String dataType;
    private final String typeName;

    public FieldCharacteristics(String id, String serializedName, String dataType) {
        this.id = id;
        this.serializedName = serializedName;
        this.tableCharacteristics = new ArrayList<TableCharacteristics>();
        this.dataType = dataType.toUpperCase();
        this.typeName = this.typeName();
    }

    public String id() {
        return this.id;
    }

    public String serializedName() {
        return this.serializedName;
    }

    public String dataType() {
        return this.dataType;
    }

    public List<TableCharacteristics> tables() {
        return this.tableCharacteristics;
    }

    void addTable(TableCharacteristics table) {
        this.tableCharacteristics.add(table);
    }

    public boolean isChar() {
        return DataTypes.CHAR_TYPES.contains(this.typeName);
    }

    public boolean isUnicode() {
        return DataTypes.UNICODE_TYPES.contains(this.typeName);
    }

    public boolean isDate() {
        return DataTypes.DATE_TYPES.contains(this.typeName);
    }

    public boolean isSimpleNonNumeric() {
        return DataTypes.SIMPLE_NON_NUMERIC_TYPES.contains(this.typeName);
    }

    public boolean isUnusual() {
        return DataTypes.UNUSUAL_TYPES.contains(this.typeName);
    }

    public int width() {
        String[] parts = this.dataType.split("\\(");
        if (DataTypes.DATE_TYPES.contains(parts[0]) || DataTypes.NUMERIC_TYPES.contains(parts[0]) || DataTypes.SIMPLE_NON_NUMERIC_TYPES.contains(parts[0]) || DataTypes.UNUSUAL_TYPES.contains(parts[0])) {
            return 1;
        }
        return this.parseDataType(parts);
    }

    private int parseDataType(String[] parts) {
        try {
            String[] parsed = parts[1].split("\\)");
            return Integer.parseInt(parsed[0]);
        }
        catch (Exception e) {
            LOG.debug("Not a known datatype. The width is set to 255." + Arrays.toString(parts));
            return 255;
        }
    }

    private String typeName() {
        String[] parts = this.dataType.split("\\(");
        return parts[0];
    }

    public String toString() {
        return "<FIELD-" + this.id + ">";
    }
}

