/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.frf.datamodel;

import com.ibm.bi.predict.explore.frf.datamodel.Cardinality;
import com.ibm.bi.predict.explore.frf.datamodel.DatabaseProvider;
import com.ibm.bi.predict.explore.frf.datamodel.FieldCharacteristics;
import com.ibm.bi.predict.explore.frf.datamodel.TableDistance;
import com.ibm.bi.predict.types.Identifiable;
import java.util.LinkedHashMap;
import java.util.Map;

public class TableCharacteristics
implements Identifiable {
    private final String id;
    private final Map<String, FieldCharacteristics> fieldCharacteristics;
    final Map<TableCharacteristics, Cardinality> relationships;
    private final DatabaseProvider provider;
    private final String namespaceId;
    private TableDistance joinInfo;

    public TableCharacteristics(String id, DatabaseProvider provider, String namespaceId) {
        this.id = id;
        this.fieldCharacteristics = new LinkedHashMap<String, FieldCharacteristics>();
        this.relationships = new LinkedHashMap<TableCharacteristics, Cardinality>();
        this.provider = provider;
        this.namespaceId = namespaceId;
        this.joinInfo = null;
    }

    public static void defineRelationship(TableCharacteristics from, TableCharacteristics to, Cardinality cardinality) {
        from.addRelationship(to, cardinality);
        to.addRelationship(from, Cardinality.reverse(cardinality));
    }

    private void addRelationship(TableCharacteristics other, Cardinality cardinality) {
        Cardinality current = this.relationships.get(other);
        this.relationships.put(other, Cardinality.better(current, cardinality));
    }

    public void addField(FieldCharacteristics field) {
        this.fieldCharacteristics.put(field.id(), field);
        field.addTable(this);
    }

    public String id() {
        return this.id;
    }

    public FieldCharacteristics getFieldById(String id) {
        return this.fieldCharacteristics.get(id);
    }

    public Map<String, FieldCharacteristics> fields() {
        return this.fieldCharacteristics;
    }

    public Map<TableCharacteristics, Cardinality> relationships() {
        return this.relationships;
    }

    public DatabaseProvider provider() {
        return this.provider;
    }

    public String namespaceId() {
        return this.namespaceId;
    }

    void setJoinInfo(TableDistance info) {
        this.joinInfo = info;
    }

    public TableDistance joinInfo() {
        return this.joinInfo;
    }

    public int separation() {
        return this.joinInfo.separation();
    }

    public int oneToManyCount() {
        return this.joinInfo.oneToManyCount();
    }

    public int manyToOneCount() {
        return this.joinInfo.manyToOneCount();
    }

    public int manyToManyCount() {
        return this.joinInfo.manyToManyCount();
    }

    public String toString() {
        return "<TABLE-" + this.id + ">";
    }

    public boolean equals(Object other) {
        if (!(other instanceof TableCharacteristics)) {
            return false;
        }
        return this.id.equals(((TableCharacteristics)other).id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

