/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.frf.framework;

import com.ibm.bi.predict.data.Context;
import com.ibm.bi.predict.explore.frf.framework.FRFConfig;
import com.ibm.bi.predict.explore.frf.framework.FRFParams;
import com.ibm.bi.predict.utils.JsonUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.json.JSON;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class FRFContext
extends Context {
    private static final String PARAMS_PREFIX = "frf.params.";
    private static final String TEMP_MODULE = "tempModule";
    private static final String REQUEST_ID = "requestId";
    private static final String MODULE_ID = "moduleId";
    private static final String TEMP_MODULE_ID = "tempModuleId";
    private static final String TARGETS = "targets";
    private static final String TARGET_FIELD_ID = "targetFieldIDForExpression";
    private static final String GET_ALL_JOINABLE_FIELDS = "getAllJoinableFields";
    private static final String GET_ALTERNATE_FIELDS = "getAlternateFields";
    private static final String SHAPED_MODULE = "shapedModule";
    private static final String NUMBER_OF_RESULTS = "numResults";
    private static final String ANALYSIS_SCOPE = "analysisScope";
    private static final String MAX_RELEVANT_FIELDS = "maxRelevantFields";
    private static final String VERSION = "version";
    public static final String FRF_PARAMS_MODULE_ID = "frf.params.moduleId";
    public static final String FRF_PARAMS_TEMP_MODULE_ID = "frf.params.tempModuleId";
    public static final String FRF_PARAMS_TEMP_MODULE = "frf.params.tempModule";
    public static final String FRF_PARAMS_TARGETS = "frf.params.targets";
    public static final String FRF_PARAMS_MAX_RELEVANT_FIELDS_FIELDS = "frf.params.maxRelevantFields";
    public static final String FRF_PARAMS_VERSION = "frf.params.version";
    public static final String FRF_PARAMS_REQUEST_ID = "frf.params.requestId";
    public static final String FRF_PARAMS_GET_ALL_JOINABLE_FIELDS = "frf.params.getAllJoinableFields";
    public static final String FRF_PARAMS_GET_ALTERNATE_FIELDS = "frf.params.getAlternateFields";
    public static final String FRF_PARAMS_SHAPED_MODULE = "frf.params.shapedModule";
    public static final String FRF_PARAMS_NUMBER_OF_RESULTS = "frf.params.numResults";
    public static final String FRF_PARAMS_ANALYSIS_SCOPE = "frf.params.analysisScope";
    public static final String FRF_CONFIG_MINIMUM_MODEL_CONFIDENCE = "frf.config.minimumModelConfidence";
    public static final String FRF_CONFIG_SMARTS_TIMEOUT_IN_MILLIS = "frf.config.smartsTimeoutInMillis";
    public static final String FRF_CONFIG_MOSER_TIMEOUT_IN_MILLIS = "frf.config.moserTimeoutInMillis";
    public static final String FRF_CONFIG_JOINGRAPH_TIMEOUT_IN_MILLIS = "frf.config.joingraphTimeoutInMillis";
    private static final String CURRENT_VERSION = "1.0";
    private Map<String, Object> httpContext;
    private JSONObject analysisScope;

    private void setHttpContext(Map<String, Object> httpContext) {
        this.httpContext = httpContext;
    }

    public void setAnalysisScope(JSONObject scope) {
        this.analysisScope = scope;
    }

    public FRFContext mixin(JSONObject params, Locale locale, Map<String, Object> httpContext) throws JSONException {
        this.setValue(FRF_PARAMS_MODULE_ID, params.optString(MODULE_ID));
        this.setValue(FRF_PARAMS_TEMP_MODULE_ID, params.optString(TEMP_MODULE_ID));
        this.setValue(FRF_PARAMS_TEMP_MODULE, params.get(TEMP_MODULE));
        this.setValue(FRF_PARAMS_TARGETS, this.getTargets(params));
        this.setValue(FRF_PARAMS_VERSION, CURRENT_VERSION);
        this.setValue(FRF_PARAMS_REQUEST_ID, params.optString(REQUEST_ID));
        this.setValue(FRF_PARAMS_MAX_RELEVANT_FIELDS_FIELDS, JsonUtils.getOptionalInt((JSONObject)params, (String)MAX_RELEVANT_FIELDS, (int)250));
        this.setValue(FRF_PARAMS_GET_ALL_JOINABLE_FIELDS, JsonUtils.getOptionalBoolean((JSONObject)params, (String)GET_ALL_JOINABLE_FIELDS, (boolean)false));
        this.setValue(FRF_PARAMS_GET_ALTERNATE_FIELDS, JsonUtils.getOptionalBoolean((JSONObject)params, (String)GET_ALTERNATE_FIELDS, (boolean)false));
        this.setValue(FRF_PARAMS_SHAPED_MODULE, JsonUtils.getOptionalBoolean((JSONObject)params, (String)SHAPED_MODULE, (boolean)false));
        this.setValue(FRF_PARAMS_NUMBER_OF_RESULTS, JsonUtils.getOptionalInt((JSONObject)params, (String)NUMBER_OF_RESULTS, (int)-1));
        this.setValue(FRF_PARAMS_ANALYSIS_SCOPE, JsonUtils.getOptionalJSONObject((JSONObject)params, (String)ANALYSIS_SCOPE));
        this.setValue("locale", locale.toString());
        this.setHttpContext(httpContext);
        return this;
    }

    public FRFContext addParams(FRFParams params) {
        this.setValue(FRF_PARAMS_MODULE_ID, params.moduleId());
        this.setValue(FRF_PARAMS_TEMP_MODULE_ID, params.tempModuleId());
        this.setValue(FRF_PARAMS_TEMP_MODULE, params.tempModule());
        ArrayList<String> targetList = new ArrayList<String>();
        for (String t : params.targets()) {
            targetList.add(t);
        }
        this.setValue(FRF_PARAMS_TARGETS, targetList);
        this.setValue(FRF_PARAMS_VERSION, params.version());
        this.setValue(FRF_PARAMS_MAX_RELEVANT_FIELDS_FIELDS, params.maxRelevantFieldsFields());
        this.setValue(FRF_PARAMS_REQUEST_ID, params.requestId());
        this.setValue(FRF_PARAMS_GET_ALL_JOINABLE_FIELDS, params.getAllJoinableFields());
        this.setValue(FRF_PARAMS_GET_ALTERNATE_FIELDS, params.getAlternateFields());
        this.setValue("locale", params.locale().toString());
        this.setValue(FRF_PARAMS_SHAPED_MODULE, params.getShapedModule());
        this.setValue(FRF_PARAMS_NUMBER_OF_RESULTS, params.getNumberOfResults());
        this.setHttpContext(params.httpContext());
        this.setAnalysisScope(params.getAnalysisScope());
        return this;
    }

    public FRFContext addConfig(FRFConfig config) {
        this.setValue(FRF_CONFIG_MINIMUM_MODEL_CONFIDENCE, config.minimumModelConfidence());
        this.setValue(FRF_CONFIG_SMARTS_TIMEOUT_IN_MILLIS, config.smartsTimeoutInMillis());
        this.setValue(FRF_CONFIG_MOSER_TIMEOUT_IN_MILLIS, config.moserTimeoutInMillis());
        return this;
    }

    public String identifierPrefix() {
        return "[" + this.getString(FRF_PARAMS_REQUEST_ID, null) + "]";
    }

    public Map<String, Object> getHttpContext() {
        return this.httpContext;
    }

    public JSONObject getAnalysisScope() {
        if (this.analysisScope != null) {
            return this.analysisScope;
        }
        return this.getJsonObject(FRF_PARAMS_ANALYSIS_SCOPE, null);
    }

    public List<String> getTargets(JSONObject params) throws JSONException {
        if (!params.containsKey((Object)TARGETS)) {
            return Arrays.asList(params.getString(TARGET_FIELD_ID));
        }
        JSONArray jsonTargets = params.getJSONArray(TARGETS);
        ArrayList<String> targets = new ArrayList<String>();
        for (int i = 0; i < jsonTargets.length(); ++i) {
            targets.add(jsonTargets.getString(i));
        }
        return targets;
    }

    public String getModuleIdToUse() {
        String id;
        if (this.getBoolean(FRF_PARAMS_SHAPED_MODULE, false) && (id = this.getString(FRF_PARAMS_TEMP_MODULE_ID, null)) != null) {
            return id;
        }
        return this.getString(FRF_PARAMS_MODULE_ID, null);
    }

    public boolean isFMPackage() {
        return FRFContext.isFMPackage(this.getString(FRF_PARAMS_TEMP_MODULE, null));
    }

    public static boolean isFMPackage(String tempModuleString) {
        if (tempModuleString == null) {
            return false;
        }
        try {
            JSONObject tempModule = (JSONObject)JSON.parse((String)tempModuleString);
            if (tempModule.containsKey((Object)"useSpec")) {
                JSONArray useSpec = tempModule.getJSONArray("useSpec");
                for (int i = 0; i < useSpec.size(); ++i) {
                    JSONObject o = useSpec.getJSONObject(i);
                    if (!o.containsKey((Object)"type") || !"package".equalsIgnoreCase(o.getString("type"))) continue;
                    return true;
                }
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return false;
    }
}

