/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.frf.moser;

import com.ibm.bi.predict.explore.frf.datamodel.DatabaseProvider;
import com.ibm.bi.predict.thirdparty.BIService;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class ContentService
extends BIService {
    private static final String OBJECTS_FIELDS_URL = "/bi/v1/objects/%s?fields=%s";

    public ContentService(Map<String, Object> httpContext) {
        super(httpContext);
    }

    public DatabaseProvider getProvider(String schemaStoreId) {
        try {
            String connectionId = this.dataSourceConnection(schemaStoreId);
            String connectionString = this.connectionString(connectionId);
            return DatabaseProvider.fromDriverName(this.driverName(connectionString));
        }
        catch (Exception e) {
            return DatabaseProvider.UNKNOWN;
        }
    }

    private String dataSourceConnection(String schemaStoreId) throws JSONException, IOException {
        JSONObject result = this.get(ContentService.dataSourceURI(schemaStoreId));
        JSONArray fields = result.getJSONArray("data");
        JSONArray parent = fields.getJSONObject(0).getJSONArray("parent");
        return parent.getJSONObject(0).getString("id");
    }

    private String connectionString(String connectionStoreId) throws JSONException, IOException {
        JSONObject result = this.get(ContentService.connectionURI(connectionStoreId));
        JSONArray fields = result.getJSONArray("data");
        return fields.getJSONObject(0).getString("connectionString");
    }

    static String dataSourceURI(String storeId) throws UnsupportedEncodingException {
        return ContentService.fieldsUrl(storeId, "parent");
    }

    static String connectionURI(String connectionStoreId) throws UnsupportedEncodingException {
        return ContentService.fieldsUrl(connectionStoreId, "connectionString");
    }

    private static String fieldsUrl(String objectStoreId, String property) throws UnsupportedEncodingException {
        return String.format(OBJECTS_FIELDS_URL, objectStoreId, URLEncoder.encode(property, "UTF-8"));
    }

    private String driverName(String connectionString) {
        String[] splitOnSemicolon;
        for (String s : splitOnSemicolon = connectionString.split(";")) {
            if (!s.contains("DRIVER_NAME")) continue;
            return s.split("=")[1];
        }
        return null;
    }
}

