/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.frf.moser;

import com.ibm.bi.predict.explore.frf.datamodel.TableCharacteristics;
import com.ibm.bi.predict.explore.frf.framework.FRFContext;
import com.ibm.bi.predict.explore.frf.moser.ContentService;
import com.ibm.bi.predict.explore.frf.moser.MoserService;
import com.ibm.bi.predict.explore.frf.moser.module.MoserTableParser;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import org.apache.commons.json.JSON;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class MoserAccess {
    private static final Logger LOGGER = PredictLoggerFactory.getLogger(MoserAccess.class);
    private final FRFContext context;
    private final Consumer<String> diagnostic;
    private final MoserService moserService;
    private final ContentService contentService;

    public MoserAccess(FRFContext context, Consumer<String> diagnostic) {
        this(context, diagnostic, new MoserService(context.getHttpContext()), new ContentService(context.getHttpContext()));
    }

    public MoserAccess(FRFContext context, Consumer<String> diagnostic, MoserService moserService, ContentService contentService) {
        this.context = context;
        this.diagnostic = diagnostic;
        this.moserService = moserService;
        this.contentService = contentService;
    }

    public List<TableCharacteristics> build(ExecutorService executor) throws Exception {
        JSONObject moduleJson = this.getMoserModule();
        if (moduleJson == null) {
            return Collections.emptyList();
        }
        return new MoserTableParser(this.context, this.diagnostic).build(executor, this.contentService, moduleJson);
    }

    private JSONObject getMoserModule() throws Exception {
        Optional<JSONObject> module = this.getFromTempModule();
        if (!module.isPresent()) {
            module = this.getFromMoserService();
        }
        return module.orElse(null);
    }

    private Optional<JSONObject> getFromTempModule() {
        return Optional.ofNullable(this.context.getString("frf.params.tempModule", null)).map(tempModule -> {
            try {
                return (JSONObject)JSON.parse((String)tempModule, (boolean)false);
            }
            catch (NullPointerException | JSONException e) {
                LOGGER.debug("Error while producing new MoserModule", e);
                return null;
            }
        });
    }

    private Optional<JSONObject> getFromMoserService() throws Exception {
        try {
            JSONObject module = this.moserService.module(this.context.getString("frf.params.moduleId", null));
            return Optional.of(module);
        }
        catch (Throwable e) {
            this.diagnostic.accept(e.getMessage());
            throw e;
        }
    }
}

