/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.frf.moser.module;

import com.ibm.bi.predict.explore.frf.datamodel.DatabaseProvider;
import com.ibm.bi.predict.explore.frf.datamodel.FieldCharacteristics;
import com.ibm.bi.predict.explore.frf.datamodel.Relationship;
import com.ibm.bi.predict.explore.frf.datamodel.TableCharacteristics;
import com.ibm.bi.predict.explore.frf.framework.FRFContext;
import com.ibm.bi.predict.explore.frf.moser.ContentService;
import com.ibm.bi.predict.explore.frf.moser.module.MoserModule;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class MoserTableParser {
    private static final Logger LOGGER = PredictLoggerFactory.getLogger(MoserTableParser.class);
    private final FRFContext context;
    private final Consumer<String> diagnostics;

    public MoserTableParser(FRFContext context, Consumer<String> diagnostics) {
        this.context = context;
        this.diagnostics = diagnostics;
    }

    public List<TableCharacteristics> build(ExecutorService executor, ContentService contentService, JSONObject tempModule) throws Exception {
        MoserModule moserModule = this.getMoserModule(tempModule);
        Map<String, DatabaseProvider> providers = this.getProviderMap(executor, contentService, moserModule);
        return this.makeTableCharacteristics(moserModule, providers);
    }

    private MoserModule getMoserModule(JSONObject tempModule) throws Exception {
        try {
            return new MoserModule(tempModule);
        }
        catch (Exception e) {
            LOGGER.debug("Error while producing new MoserModule", (Throwable)e);
            throw e;
        }
    }

    private Map<String, DatabaseProvider> getProviderMap(ExecutorService executor, ContentService contentService, MoserModule moserModule) {
        Map<String, String> idToStore = moserModule.getUseSpecStoreIds();
        Future<Map> providerFuture = executor.submit(() -> this.getProviders(contentService, idToStore));
        try {
            return providerFuture.get((long)this.context.getInt("frf.config.moserTimeoutInMillis", 20000) / 3L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            LOGGER.debug("return empty providers, possibly due to timeout", (Throwable)e);
            return Collections.emptyMap();
        }
    }

    private Map<String, DatabaseProvider> getProviders(ContentService contentService, Map<String, String> idToStore) {
        HashMap<String, DatabaseProvider> providers = new HashMap<String, DatabaseProvider>();
        for (Map.Entry<String, String> e : idToStore.entrySet()) {
            providers.put(e.getKey(), contentService.getProvider(e.getValue()));
        }
        return providers;
    }

    private List<TableCharacteristics> makeTableCharacteristics(MoserModule moserModule, Map<String, DatabaseProvider> providers) {
        List<TableCharacteristics> tables = moserModule.tableIds().stream().map(id -> MoserTableParser.makeTable(id, moserModule, this.providerForTable(moserModule, providers, (String)id), this.namespaceId(moserModule, (String)id))).collect(Collectors.toList());
        Map<String, TableCharacteristics> tableByID = tables.stream().collect(Collectors.toMap(TableCharacteristics::id, t -> t));
        moserModule.relationships().forEach((id, relationships) -> this.setTableRelationships((String)id, (List<Relationship>)relationships, tableByID));
        return tables;
    }

    public static TableCharacteristics makeTable(String id, MoserModule moserModule, DatabaseProvider provider, String namespaceId) {
        TableCharacteristics table = new TableCharacteristics(id, provider, namespaceId);
        MoserTableParser.makeFieldCharacteristics(table, moserModule.fields(id));
        return table;
    }

    private static void makeFieldCharacteristics(TableCharacteristics table, List<JSONObject> fieldDefinitions) {
        if (fieldDefinitions == null) {
            return;
        }
        String tableId = table.id();
        for (JSONObject queryItem : fieldDefinitions) {
            try {
                String fieldName = queryItem.getString("identifier");
                String dataType = queryItem.optString("datatype", "NULL");
                String idForExpression = queryItem.optString("idForExpression", null);
                if (idForExpression == null) {
                    idForExpression = tableId + "." + fieldName;
                }
                table.addField(new FieldCharacteristics(idForExpression, fieldName, dataType));
            }
            catch (JSONException e) {
                throw new RuntimeException("Error parsing field definition", e);
            }
        }
    }

    private void setTableRelationships(String id, List<Relationship> rel, Map<String, TableCharacteristics> map) {
        TableCharacteristics table = map.get(id);
        if (table == null) {
            LOGGER.error("Unknown table as key in relationships: {}", (Object)id);
            return;
        }
        for (Relationship r : rel) {
            TableCharacteristics other = map.get(r.id());
            if (other == null) {
                LOGGER.error("Unknown table as value in relationships: {}", (Object)r.id());
                continue;
            }
            TableCharacteristics.defineRelationship(table, other, r.cardinality());
        }
    }

    private DatabaseProvider providerForTable(MoserModule moserModule, Map<String, DatabaseProvider> providers, String tableName) {
        String ref = moserModule.tableRefs().get(tableName);
        return providers.getOrDefault(ref, DatabaseProvider.UNKNOWN);
    }

    private String namespaceId(MoserModule moserModule, String tableName) {
        String ref = moserModule.tableRefs().get(tableName);
        try {
            return moserModule.namespaceId(tableName, ref);
        }
        catch (Exception e) {
            this.diagnostics.accept(e.getMessage());
            throw e;
        }
    }
}

