/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.frf.performance;

import com.ibm.bi.predict.explore.frf.datamodel.FieldCharacteristics;
import com.ibm.bi.predict.explore.frf.datamodel.SampleTableSelection;
import com.ibm.bi.predict.explore.frf.datamodel.TableCharacteristics;
import com.ibm.bi.predict.explore.frf.datamodel.TableDistanceAlgorithm;
import com.ibm.bi.predict.explore.frf.framework.ExpectedQueryPerformance;
import com.ibm.bi.predict.explore.frf.performance.BaseModel;
import com.ibm.bi.predict.explore.frf.performance.PerformancePrediction;
import com.ibm.bi.predict.explore.frf.performance.QueryDescription;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.ToDoubleFunction;

public class PerformanceModel {
    private static final Logger LOGGER = PredictLoggerFactory.getLogger(PerformanceModel.class);
    private static final String fastModelPath = "fast-prediction.json";
    private static final String mediumModelPath = "med-prediction.json";
    private static final String fastModelUnknownPath = "fast-prediction-unknown.json";
    private static final String mediumModelUnknownPath = "med-prediction-unknown.json";
    private static final BaseModel sharedFastModel = new BaseModel("fast-prediction.json", "fast-prediction-unknown.json");
    private static final BaseModel sharedMediumModel = new BaseModel("med-prediction.json", "med-prediction-unknown.json");
    private final String identifierPrefix;
    private final ToDoubleFunction<QueryDescription> fastModel;
    private final ToDoubleFunction<QueryDescription> mediumModel;
    private final double minimumConfidence;
    private final Map<String, TableCharacteristics> connectedTables;
    private final SampleTableSelection sts;

    public static PerformanceModel makeFor(String identifierPrefix, Map<String, TableCharacteristics> tables, double minimumConfidence) {
        return PerformanceModel.makeFor(identifierPrefix, tables, minimumConfidence, fastModelPath, mediumModelPath);
    }

    public static PerformanceModel makeFor(String identifierPrefix, Map<String, TableCharacteristics> tables, double minimumConfidence, String fastModelPath, String mediumModelPath) {
        return new PerformanceModel(identifierPrefix, tables, sharedFastModel::confidenceForYes, sharedMediumModel::confidenceForYes, minimumConfidence);
    }

    public static PerformanceModel defaultModel() {
        return new PerformanceModel(null, Collections.emptyMap(), null, null, 0.0);
    }

    public PerformanceModel(String identifierPrefix, Map<String, TableCharacteristics> tables, ToDoubleFunction<QueryDescription> fastModel, ToDoubleFunction<QueryDescription> mediumModel, double minimumConfidence) {
        this.identifierPrefix = identifierPrefix;
        this.fastModel = fastModel;
        this.mediumModel = mediumModel;
        this.minimumConfidence = minimumConfidence;
        this.connectedTables = tables;
        this.sts = new SampleTableSelection(tables);
    }

    public PerformancePrediction predict(List<FieldCharacteristics> relevantFields) {
        if (this.connectedTables.isEmpty()) {
            return PerformancePrediction.KNOWN_FAST;
        }
        long t1 = System.currentTimeMillis();
        String samplingTableId = this.sts.selectSampleTable(relevantFields);
        TableCharacteristics samplingTable = this.connectedTables.get(samplingTableId);
        long t2 = System.currentTimeMillis();
        TableDistanceAlgorithm.setDistances(samplingTable);
        long t3 = System.currentTimeMillis();
        double confidenceFast = this.getConfidence(this.fastModel, relevantFields);
        long t4 = System.currentTimeMillis();
        double confidenceMedium = this.getConfidence(this.mediumModel, relevantFields);
        long t5 = System.currentTimeMillis();
        LOGGER.debug(() -> String.format("%s PerformancePrediction selectSampleTable %d ms, setDistances %d ms, fastModel %d ms, mediumModel %d ms", this.identifierPrefix, t2 - t1, t3 - t2, t4 - t3, t5 - t4));
        if (Double.isNaN(confidenceFast + confidenceMedium)) {
            LOGGER.error(() -> this.identifierPrefix + "Model building failed");
            return PerformancePrediction.UNKNOWN;
        }
        if (confidenceFast > this.minimumConfidence) {
            return new PerformancePrediction(ExpectedQueryPerformance.FAST, confidenceFast);
        }
        if (confidenceMedium > this.minimumConfidence) {
            return new PerformancePrediction(ExpectedQueryPerformance.MEDIUM, confidenceMedium);
        }
        return new PerformancePrediction(ExpectedQueryPerformance.SLOW, confidenceMedium);
    }

    private double getConfidence(ToDoubleFunction<QueryDescription> model, List<FieldCharacteristics> relevantFields) {
        QueryDescription query = new QueryDescription(Collections.emptyList(), relevantFields);
        try {
            return model.applyAsDouble(query);
        }
        catch (Exception e) {
            LOGGER.error(this.identifierPrefix + "Error scoring " + model, (Throwable)e);
            return Double.NaN;
        }
    }
}

