/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.frf.performance;

import com.ibm.bi.predict.explore.frf.datamodel.DatabaseProvider;
import com.ibm.bi.predict.explore.frf.datamodel.FieldCharacteristics;
import com.ibm.bi.predict.explore.frf.datamodel.TableCharacteristics;
import com.ibm.bi.predict.explore.frf.performance.ModelCharacteristic;
import com.ibm.bi.predict.fastpattern.exceptions.FastPatternException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.stream.Stream;

public class QueryDescription {
    private final List<FieldCharacteristics> targets;
    private final List<FieldCharacteristics> other;

    public QueryDescription(List<FieldCharacteristics> targets, List<FieldCharacteristics> other) {
        this.targets = targets;
        this.other = other;
    }

    public List<FieldCharacteristics> targets() {
        return this.targets;
    }

    public List<FieldCharacteristics> other() {
        return this.other;
    }

    public Map<String, Object> getAggregatedFieldValues() {
        HashMap<String, Object> fieldCharacteristics = new HashMap<String, Object>();
        fieldCharacteristics.put(ModelCharacteristic.PROVIDER.toString(), (Object)this.getProvider());
        HashSet tables = new HashSet();
        Stream.concat(this.other.stream(), this.targets.stream()).forEach(field -> {
            this.increment(fieldCharacteristics, ModelCharacteristic.IS_CHAR_COUNT.toString(), 1, field::isChar);
            this.increment(fieldCharacteristics, ModelCharacteristic.IS_UNICODE_COUNT.toString(), 1, field::isUnicode);
            this.increment(fieldCharacteristics, ModelCharacteristic.IS_DATE_COUNT.toString(), 1, field::isDate);
            this.increment(fieldCharacteristics, ModelCharacteristic.IS_SIMPLE_NON_NUMERIC_COUNT.toString(), 1, field::isSimpleNonNumeric);
            this.increment(fieldCharacteristics, ModelCharacteristic.IS_UNUSUAL_COUNT.toString(), 1, field::isUnusual);
            this.updateMax(fieldCharacteristics, ModelCharacteristic.MAX_WIDTH.toString(), field.width());
            tables.addAll(field.tables());
        });
        fieldCharacteristics.put(ModelCharacteristic.TABLE_COUNT.toString(), tables.size());
        for (TableCharacteristics table : tables) {
            this.increment(fieldCharacteristics, ModelCharacteristic.ONE_TO_N_COUNT.toString(), table.oneToManyCount());
            this.increment(fieldCharacteristics, ModelCharacteristic.N_TO_N_COUNT.toString(), table.manyToManyCount());
            this.increment(fieldCharacteristics, ModelCharacteristic.N_TO_ONE_COUNT.toString(), table.manyToOneCount());
            this.updateMax(fieldCharacteristics, ModelCharacteristic.MAX_SEPARATION.toString(), table.separation());
            this.increment(fieldCharacteristics, "tBadJoins", table.oneToManyCount());
            this.increment(fieldCharacteristics, "tBadJoins", table.manyToManyCount());
            this.increment(fieldCharacteristics, "tAllJoins", table.oneToManyCount());
            this.increment(fieldCharacteristics, "tAllJoins", table.manyToManyCount());
            this.increment(fieldCharacteristics, "tAllJoins", table.manyToOneCount());
        }
        return fieldCharacteristics;
    }

    private DatabaseProvider getProvider() {
        if (this.targets.isEmpty()) {
            return this.getProvider(this.other.get(0).tables());
        }
        return this.getProvider(this.targets.get(0).tables());
    }

    private DatabaseProvider getProvider(List<TableCharacteristics> tables) {
        for (TableCharacteristics t : tables) {
            if (t.provider() == DatabaseProvider.UNKNOWN) continue;
            return t.provider();
        }
        return DatabaseProvider.UNKNOWN;
    }

    private void increment(Map<String, Object> map, String key, int value, BooleanSupplier condition) {
        map.putIfAbsent(key, 0);
        try {
            if (condition.getAsBoolean()) {
                map.merge(key, value, (a, b) -> (Integer)a + (Integer)b);
            }
        }
        catch (Exception e) {
            throw new FastPatternException(String.format("Could not increment key: %s by value: %s with message %s", key, value, e.getMessage()), e);
        }
    }

    private void increment(Map<String, Object> map, String key, int value) {
        this.increment(map, key, value, () -> true);
    }

    private void updateMax(Map<String, Object> map, String key, int value) {
        map.putIfAbsent(key, 0);
        try {
            map.merge(key, value, (a, b) -> (Integer)a > (Integer)b ? a : b);
        }
        catch (Exception e) {
            throw new FastPatternException(String.format("Could not update the max value for key: %s with value: %s with message: %s", key, value, e.getMessage()), e);
        }
    }
}

