/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.frf.performance;

import com.ibm.bi.predict.explore.frf.datamodel.FieldCharacteristics;
import com.ibm.bi.predict.explore.frf.datamodel.TableCharacteristics;
import com.ibm.bi.predict.explore.frf.smarts.FieldSmartsRelevance;

public class RelevanceByDistance {
    private RelevanceByDistance() {
    }

    public static FieldSmartsRelevance calculateRelevance(FieldCharacteristics field) {
        double relevance = field.tables().stream().filter(t -> t.joinInfo() != null).map(RelevanceByDistance::relevance).sorted((d1, d2) -> Double.compare(d2, d1)).findFirst().orElse(0.0);
        return new FieldSmartsRelevance(field.id(), relevance);
    }

    private static double relevance(TableCharacteristics table) {
        int fieldCountInTable = table.fields().size();
        int tableSeparation = table.separation();
        return 1.0 / ((double)(1 + tableSeparation) - (double)fieldCountInTable / 1000000.0 + (double)(10000 * table.oneToManyCount()));
    }
}

