/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.fastpattern;

import com.google.common.primitives.Ints;
import com.ibm.bi.predict.algorithms.EvaluationStatistic;
import com.ibm.bi.predict.algorithms.tree.util.TreeParameters;
import com.ibm.bi.predict.data.Category;
import com.ibm.bi.predict.data.DataContext;
import com.ibm.bi.predict.exceptions.BadParametersException;
import com.ibm.bi.predict.exceptions.PredictException;
import com.ibm.bi.predict.fastpattern.FastPatternParams;
import com.ibm.bi.predict.fastpattern.algorithm.AlgorithmType;
import com.ibm.bi.predict.fastpattern.util.FastPatternConfig;
import com.ibm.bi.predict.thirdparty.FieldIdAndType;
import com.ibm.bi.predict.utils.JsonUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class FastPatternContext
extends DataContext {
    private EvaluationStatistic accuracyMeasureContTarget = EvaluationStatistic.ADJ_R2;
    private EvaluationStatistic accuracyMeasureCatTarget = EvaluationStatistic.CLASSIFICATION_ACCURACY;
    private TreeParameters categoricalTreeParameters = TreeParameters.categorical();
    private TreeParameters continuousTreeParameters = TreeParameters.continuous();

    public FastPatternContext mixinParameters(JSONObject params) {
        super.setIfPresent("sampledData", (Map)params);
        this.setIfPresent("fpd.config.maxKeyDriversToReturn", (Map)params);
        this.setIfPresent("fpd.config.useParallelProcessing", (Map)params);
        this.setIfPresent("fpd.config.allowKeyDriverCategoricalTarget", (Map)params);
        this.setIfPresent("fpd.config.driverSearchPairs", (Map)params);
        this.setIfPresent("fpd.config.pValueForTests", (Map)params);
        this.setIfPresent("fpd.config.minimumAdjustedRSquared", (Map)params);
        this.setIfPresent("fpd.config.improvementThreshold", (Map)params);
        this.setIfPresent("fpd.config.moderateAccuracyThreshold", (Map)params);
        this.setIfPresent("fpd.config.strongAccuracyThreshold", (Map)params);
        this.setIfPresent("fpd.config.datasetId", (Map)params);
        this.setIfPresent("fpd.config.target", (Map)params);
        this.setIfPresent("fpd.config.targetId", (Map)params);
        this.setIfPresent("fpd.config.inputs", (Map)params);
        this.set("fpd.config.methods", params, this::processMethods);
        this.setIfPresent("fpd.config.version", (Map)params);
        this.setIfPresent("fpd.config.filters", (Map)params);
        this.setIfPresent("fpd.config.dataFilters", (Map)params);
        this.setIfPresent("fpd.config.categoricalChisquareAdjustThreshold", (Map)params);
        return this;
    }

    public FastPatternContext addParams(FastPatternParams params) {
        this.addParamsInfo(params);
        return this;
    }

    public FastPatternContext addConfig(FastPatternConfig config) {
        this.setValue("fpd.config.maxKeyDriversToReturn", config.maxKeyDriversToReturn());
        this.setValue("fpd.config.useParallelProcessing", config.useParallelProcessing());
        this.setValue("fpd.config.allowKeyDriverCategoricalTarget", config.getAllowKeyDriverCategoricalTarget());
        this.setValue("fpd.config.pValueForTests", config.pValueForTests());
        this.setValue("fpd.config.minimumAdjustedRSquared", config.minimumAdjustedRSquared());
        this.setValue("fpd.config.improvementThreshold", config.minimumImprovementThreshold());
        this.setValue("fpd.config.moderateAccuracyThreshold", config.moderateAccuracyThreshold());
        this.setValue("fpd.config.strongAccuracyThreshold", config.strongAccuracyThreshold());
        this.accuracyMeasureContTarget = config.accuracyMeasureContTarget();
        this.accuracyMeasureCatTarget = config.accuracyMeasureCatTarget();
        this.categoricalTreeParameters = config.getCategoricalTreeParameters();
        this.continuousTreeParameters = config.getContinuousTreeParameters();
        ArrayList<Integer> driverSearchPairs = new ArrayList<Integer>();
        for (int i : config.driverSearchPairs()) {
            driverSearchPairs.add(i);
        }
        this.setValue("fpd.config.driverSearchPairs", driverSearchPairs);
        return this;
    }

    public FastPatternContext loadDataContextProperties(JSONObject obj) {
        super.parseJson(obj);
        return this;
    }

    public AlgorithmType[] getMethods() {
        return this.getStringListOpt("fpd.config.methods").map(l -> (AlgorithmType[])l.stream().map(AlgorithmType::fromString).toArray(AlgorithmType[]::new)).orElseThrow(BadParametersException::new);
    }

    public Optional<String> getTargetId() {
        return this.getTarget().map(FieldIdAndType::id);
    }

    public Optional<FieldIdAndType> getTarget() {
        return this.getJsonObjectOpt("fpd.config.target").map(this::fieldObjToTuple);
    }

    public Optional<List<FieldIdAndType>> getInputs() {
        return this.getJsonArrayOpt("fpd.config.inputs").map(arr -> {
            if (!arr.isEmpty() && arr.get(0) instanceof String) {
                return Collections.emptyList();
            }
            return this.typedStream((Collection<?>)arr, (Class)JSONObject.class).map(this::fieldObjToTuple).collect(Collectors.toList());
        });
    }

    public Optional<List<String>> getInputIds() {
        return this.getJsonArrayOpt("fpd.config.inputs").map(arr -> {
            if (arr.isEmpty()) {
                return Collections.emptyList();
            }
            if (arr.get(0) instanceof String) {
                return this.typedStream((Collection<?>)arr, (Class)String.class).collect(Collectors.toList());
            }
            return this.typedStream((Collection<?>)arr, (Class)JSONObject.class).map(this::fieldObjToTuple).map(FieldIdAndType::id).collect(Collectors.toList());
        });
    }

    public boolean isSampledData() {
        return this.getBoolean("sampledData", false);
    }

    private FieldIdAndType fieldObjToTuple(JSONObject field) {
        String id = JsonUtils.getRequiredString((JSONObject)field, (String)"id");
        String type = JsonUtils.getRequiredString((JSONObject)field, (String)"type");
        return FieldIdAndType.from((String)id, (String)type);
    }

    public int[] getDriverIndices() {
        return this.getIntListOpt("fpd.config.inputs").map(Ints::toArray).orElseThrow(BadParametersException::new);
    }

    public String getVersion() {
        return (String)this.getStringOpt("fpd.config.version").orElseThrow(BadParametersException::new);
    }

    public String getDataSetId() {
        return (String)this.getStringOpt("fpd.config.datasetId").orElseThrow(BadParametersException::new);
    }

    public Optional<JSONArray> getFilters() {
        return this.getJsonArrayOpt("fpd.config.filters");
    }

    public Optional<JSONArray> getDataFilters() {
        return this.getJsonArrayOpt("fpd.config.dataFilters");
    }

    public Optional<Integer> getTopCountFromFilters() {
        return this.getFilters().filter(filters -> !filters.isEmpty()).map(filters -> {
            try {
                JSONObject filter = filters.getJSONObject(0);
                if (filter.has("topcount")) {
                    return filter.getInt("topcount");
                }
                return Integer.MAX_VALUE;
            }
            catch (JSONException e) {
                throw new PredictException("Error while getting topcount property from filters. Reason: " + e.getMessage(), (Throwable)e);
            }
        });
    }

    public EvaluationStatistic getAccuracyMeasureContTarget() {
        return this.accuracyMeasureContTarget;
    }

    public EvaluationStatistic getAccuracyMeasureCatTarget() {
        return this.accuracyMeasureCatTarget;
    }

    public TreeParameters getCategoricalTreeParameters() {
        return this.categoricalTreeParameters;
    }

    public TreeParameters getContinuousTreeParameters() {
        return this.continuousTreeParameters;
    }

    public FastPatternContext setCategoricalTreeParameters(TreeParameters parameters) {
        this.categoricalTreeParameters = parameters;
        return this;
    }

    public FastPatternContext setContinuousTreeParameters(TreeParameters parameters) {
        this.continuousTreeParameters = parameters;
        return this;
    }

    public FastPatternContext setAccuracyMeasureContTarget(EvaluationStatistic accuracyMeasure) {
        this.accuracyMeasureContTarget = accuracyMeasure;
        return this;
    }

    public FastPatternContext setAccuracyMeasureCatTarget(EvaluationStatistic accuracyMeasure) {
        this.accuracyMeasureCatTarget = accuracyMeasure;
        return this;
    }

    public Comparator<Category> getTargetCategorySortingStrategy() {
        return this.categoricalTreeParameters.getTargetCategorySortingStrategy(this.getLocale("locale"));
    }

    public double getCategoricalChisquareAdjustThreshold() {
        return this.getDouble("fpd.config.categoricalChisquareAdjustThreshold", 0.0);
    }

    public int getMinCategoryFrequency() {
        return this.getInt("fpd.config.minimumCategoryFrequency", 0);
    }

    protected String configPrefix() {
        return "fpd.config.";
    }

    private Object processMethods(Object obj) {
        if (obj != null && !(obj instanceof JSONArray)) {
            throw new BadParametersException("Expected 'methods' to be JSON array");
        }
        JSONArray methods = (JSONArray)obj;
        if (methods == null || methods.isEmpty()) {
            try {
                return new JSONArray(AlgorithmType.allMethods());
            }
            catch (JSONException e) {
                throw new PredictException("Error while creating JSON array. Reason: " + e.getMessage(), (Throwable)e);
            }
        }
        TreeSet<String> processed = new TreeSet<String>();
        for (int i = 0; i < methods.size(); ++i) {
            try {
                String method = methods.getString(i);
                if ("drivers".equals(method)) {
                    processed.add(AlgorithmType.fromString("oneway").toString());
                    processed.add(AlgorithmType.fromString("twoway").toString());
                    processed.add(AlgorithmType.fromString("tree").toString());
                    continue;
                }
                processed.add(AlgorithmType.fromString(method).toString());
                continue;
            }
            catch (JSONException e) {
                throw new BadParametersException("Invalid method name: " + FastPatternContext.getMethodName(methods, i), (Throwable)e);
            }
        }
        try {
            return new JSONArray(processed);
        }
        catch (JSONException e) {
            throw new BadParametersException("Error while creating methods array", (Throwable)e);
        }
    }

    private static String getMethodName(JSONArray methods, int idx) {
        try {
            return methods.getString(idx);
        }
        catch (JSONException e) {
            throw new BadParametersException("Error while getting method. Reason" + e.getMessage(), (Throwable)e);
        }
    }

    private <T> Stream<T> typedStream(Collection<?> s, Class<T> clazz) {
        return s.stream().map(clazz::cast);
    }

    public static class ConfigKeys {
        public static final String CONFIG_PREFIX = "fpd.config.";
        public static final String MAX_KEY_DRIVERS_TO_RETURN = "fpd.config.maxKeyDriversToReturn";
        public static final String USE_PARALLEL_PROCESSING = "fpd.config.useParallelProcessing";
        public static final String ALLOW_KEY_DRIVER_CATEGORICAL_TARGET = "fpd.config.allowKeyDriverCategoricalTarget";
        public static final String DRIVER_SEARCH_PAIRS = "fpd.config.driverSearchPairs";
        public static final String P_VALUE_FOR_TESTS = "fpd.config.pValueForTests";
        public static final String MINIMUM_ADJUSTED_R_SQUARED = "fpd.config.minimumAdjustedRSquared";
        public static final String IMPROVEMENT_THRESHOLD = "fpd.config.improvementThreshold";
        public static final String MODERATE_ACCURACY_THRESHOLD = "fpd.config.moderateAccuracyThreshold";
        public static final String STRONG_ACCURACY_THRESHOLD = "fpd.config.strongAccuracyThreshold";
        public static final String DATASET_ID = "fpd.config.datasetId";
        public static final String TARGET = "fpd.config.target";
        public static final String TARGET_ID = "fpd.config.targetId";
        public static final String INPUTS = "fpd.config.inputs";
        public static final String METHODS = "fpd.config.methods";
        public static final String VERSION = "fpd.config.version";
        public static final String FILTERS = "fpd.config.filters";
        public static final String DATA_FILTERS = "fpd.config.dataFilters";
        public static final String CATEGORICAL_CHISQUARE_ADJUST_THRESHOLD = "fpd.config.categoricalChisquareAdjustThreshold";
        public static final String MINIMUM_CATEGORY_FREQUENCY = "fpd.config.minimumCategoryFrequency";
    }
}

