/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.fastpattern.algorithm;

import com.ibm.bi.predict.data.DataPrep;
import com.ibm.bi.predict.fastpattern.FastPatternContext;
import com.ibm.bi.predict.fastpattern.algorithm.Algorithm;
import com.ibm.bi.predict.fastpattern.algorithm.AlgorithmType;
import com.ibm.bi.predict.fastpattern.chaid.TreeAlgorithm;
import com.ibm.bi.predict.fastpattern.keydrivers.KeyDriver;
import com.ibm.bi.predict.fastpattern.keydrivers.OneWayKeyDriver;
import com.ibm.bi.predict.fastpattern.keydrivers.OneWayKeyDriverAlgorithm;
import com.ibm.bi.predict.fastpattern.keydrivers.TwoWayKeyDriverAlgorithm;
import com.ibm.bi.predict.result.ExecutionResult;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.lang.reflect.Constructor;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class AlgorithmFactory {
    private static final Logger LOG = PredictLoggerFactory.getLogger(AlgorithmFactory.class);
    private Map<AlgorithmType, Class<? extends Algorithm<? extends ExecutionResult<List<KeyDriver>>>>> algorithms = new EnumMap<AlgorithmType, Class<? extends Algorithm<? extends ExecutionResult<List<KeyDriver>>>>>(AlgorithmType.class);

    public AlgorithmFactory() {
        this.algorithms.put(AlgorithmType.ONE_WAY_KEY_DRIVERS, OneWayKeyDriverAlgorithm.class);
        this.algorithms.put(AlgorithmType.TWO_WAY_KEY_DRIVERS, TwoWayKeyDriverAlgorithm.class);
        this.algorithms.put(AlgorithmType.TREE, TreeAlgorithm.class);
    }

    public Optional<Algorithm<? extends ExecutionResult<List<KeyDriver>>>> getAlgorithm(AlgorithmType algorithmType, DataPrep dataPrep, FastPatternContext context, List<OneWayKeyDriver> oneway) {
        try {
            Constructor<? extends Algorithm<? extends ExecutionResult<List<KeyDriver>>>> algorithm = this.algorithms.get((Object)algorithmType).getDeclaredConstructor(DataPrep.class, FastPatternContext.class, List.class);
            Algorithm<? extends ExecutionResult<List<KeyDriver>>> instance = algorithm.newInstance(new Object[]{dataPrep, context, oneway});
            return Optional.of(instance);
        }
        catch (Exception e) {
            LOG.warn(String.format("Could not generate algorithm for %s due to error: %s", new Object[]{algorithmType, e}));
            return Optional.empty();
        }
    }
}

